; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; negate

; ---conformance---
; Sketchy Core

; ---purpose---
; Compute the negative value of a number.

; ---args---
; X - number

; ---keywords---
; NEGATIVE function, negative value, arithmetics

; ---see-also---
; digits, -, negative?

; ---example---
; (negate 125) => -125

(define negate #t)

:require digits.l

; ---code---
(define (negate x)
  (letrec ((_negate (lambda (x)
      (cond ((eq? (car x) '-) (cdr x))
        ((eq? (car x) '+) (cons '- (cdr x)))
        (#t (cons '- x))))))
    (list->integer
      (_negate (integer->list x)) #t)))

