; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; natural?

; ---conformance---
; Sketchy Core

; ---purpose---
; Test whether a number is a natural number.
; See DIGITS for defintions of numbers.

; ---args---
; A - number

; ---keywords---
; NATURAL? function, numbers, digit, predicate, natural

; ---see-also---
; digits, natural

; ---example---
; (natural? 567) => #t

(define naturalp #t)

:require digits.l
:require non-negativep.l

; ---code---
(define (natural? a)
  (non-negative? a))

