; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; natural

; ---conformance---
; Sketchy Core

; ---purpose---
; Convert an integer or natural number to a natural number.
; Integers must be positive in order to convert them.

; ---args---
; A - number

; ---keywords---
; NATURAL function, numeric, numbers, digit, natural

; ---see-also---
; digits, integer, natural?

; ---example---
; (natural +123) => 123

(define natural #t)

:require digits.l
:require list.l
:require integer.l

; ---code---
(define (natural x)
  (letrec
    ((_natural (lambda (list-x)
      (cond ((eq? (car list-x) '+) (cdr list-x))
        ((eq? (car list-x) '-)
          (bottom (list 'natural x)))
        (#t list-x)))))
    (list->integer (_natural (integer->list x)) #t)))

