; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; modulo

; ---conformance---
; R5RS

; ---purpose---
; Compute the modulo of two numbers.

; ---args---
; A - number (dividend)
; B - number (divisor)

; ---keywords---
; MODULO function, division, remainder, division remainder
; modulus, arithmetics

; ---see-also---
; digits, remainder, quotient, divide, +, -, *

; ---example---
; (modulo 123 -23) => -15

(define modulo #t)

:require remainder.l
:require negativep.l negative?
:require plus.l +

; ---code---
(define (modulo a b)
  (let ((rem (remainder a b)))
    (cond ((eq? (negative? a) (negative? b))
        rem)
      (#t (+ b rem)))))

