; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; -

; ---conformance---
; R5RS

; ---purpose---
; Subtract numbers. If only one argument is given,
; return its negative value.

; ---args---
; A - number
; B... - numbers (to be subtracted)

; ---keywords---
; - function, difference, subtract, subtraction
; arithmetics

; ---see-also---
; digits, +, *, quotient, remainder, n-

; ---example---
; (- 5 7) => -2

(define minus #t)

:require digits.l
:require abs.l
:require plus.l +
:require integer.l
:require negate.l
:require iterate.l
:require negativep.l negative?

; ---code---
(define (- a . b)
  (letrec

    ((idiff (lambda (a b)
      (cond ((negative? b)
          (+ a (abs b)))    ; B<0
        ((negative? a)
          (+ a (negate b))) ; B>=0, A<0
        ((n< (abs a) (abs b))
          (negate (n- (abs b) (abs a))))  ; A>=0, B>=0, A<B
        (#t (n- (abs a) (abs b))))))      ; A>=0, B>=0, A>=B

    (i- (lambda (a b)
      (idiff (integer a) (integer b)))))

    (cond ((null? b) (negate a))
      (#t (iterate i- (cons a b) #f)))))

