; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; min

; ---conformance---
; R5RS

; ---purpose---
; Find the minimum of some numbers.

; ---args---
; A - number
; B... - numbers

; ---keywords---
; MIN function, minimum, comparison, arithmetics

; ---see-also---
; digits, max, <

; ---example---
; (min 25 5 -25 0 -5) => -25

(define min #t)

:require caar.l cadr cddr
:require less.l <

; ---code---
(define (min a . b)
  (letrec ((_min (lambda (a)
      (cond ((null? (cdr a)) (car a))
        ((< (car a) (cadr a))
          (_min (cons (car a) (cddr a))))
        (#t (_min (cdr a)))))))
    (cond ((null? b) a)
      (#t (_min (cons a b))))))

