; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; memq

; ---conformance---
; R5RS

; ---purpose---
; Check whether a list has a member that is identical to a
; given symbol. If such a member exists, return the tail of
; the list beginning with that member. If no such member is
; found, return #F.

; ---args---
; X - symbol to find
; A - list

; ---keywords---
; MEMQ function, member of, sets, set theory

; ---see-also---
; member, assq

; ---example---
; (memq 'c '(a b c d e f)) => (c d e f)

; ---model---
; (define memq (lambda (x a)
;   (cond ((null? a) #f)
;     ((eq? (car a) x) a)
;     (#t (memq x (cdr a))))))

(define memq #t)

; ---code---
(define (memq x a)
  (letrec
    ((_memq (lambda (a)
      (cond ((null? a) #f)
        ((eq? (car a) x) a)
        (#t (_memq (cdr a)))))))
    (_memq a)))

