; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; member

; ---conformance---
; R5RS

; ---purpose---
; Check whether a list has a member that is equal to a given
; S-expression. If such a member exists, return the tail of
; the list beginning with that member. If no such member is
; found, return #F.

; ---args---
; X - expression to find
; A - list

; ---keywords---
; MEMBER function, member of, sets, set theory

; ---see-also---
; memq, assoc

; ---example---
; (member '(c d) '(a b (c d) e f)) => ((c d) e f)

(define member #t)

:require equalp.l equal?

; ---model---
; (define (member x a)
;   (cond ((null? a) #f)
;     ((equal? (car a) x) a)
;     (#t (member x (cdr a)))))

; ---code---
(define (member x a)
  (letrec
    ((_member (lambda (a)
      (cond ((null? a) #f)
        ((equal? (car a) x) a)
        (#t (_member (cdr a)))))))
    (_member a)))

