; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; max

; ---conformance---
; R5RS

; ---purpose---
; Find the maximum of a list of numbers.

; ---args---
; A - number
; B... - numbers

; ---keywords---
; MAX function, maximum, comparison, arithmetics

; ---see-also---
; digits, min, >

; ---example---
; (max -25 5 25 0 -5) => 25

(define max #t)

:require caar.l cadr cddr
:require greater.l >

; ---code---
(define (max a . b)
  (letrec
    ((_max (lambda (a)
      (cond ((null? (cdr a)) (car a))
        ((> (car a) (cadr a))
          (_max (cons (car a) (cddr a))))
        (#t (_max (cdr a)))))))
    (cond ((null? b) a)
      (#t (_max (cons a b))))))

