; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; map

; ---conformance---
; R5RS

; ---purpose---
; Map an N-ary function F over N lists, giving
; a single result list.
; F is applied to the the list consisting of the
; car of each argument list, giving the first
; member of the result list. MAP then proceeds
; with the cadr parts of each list, giving the
; next member of the result list, etc.

; ---args---
; F - function to apply
; A... - lists

; ---keywords---
; MAP function, mapping, lists, CAR

; ---see-also---
; member, list?, iterate

; ---example---
; (map cons '(a b c) '(d e f)) => ((a . d) (b . e) (c . f))

(define map #t)

:require reverse.l
:require not.l
:require caar.l cdar

; ---code---
(define (map f . a)
  (letrec
    ((map-list (lambda (f a r)
      (cond ((null? a) (reverse r))
        (#t (map-list f (cdr a)
                      (cons (f (car a)) r))))))
    (carof (lambda (a)
      (map-list car a '())))
    (cdrof (lambda (a)
      (map-list cdr a '())))
    (any-null? (lambda (a)
      (cond ((null? a) #f)
	((null? (car a)) #t)
	(#t (any-null? (cdr a))))))
    (_map (lambda (a b)
      (cond ((any-null? a) (reverse b))
        (#t (_map (cdrof a)
              (cons (apply f (carof a)) b)))))))
    (cond ((null? a)
        (bottom '(too few arguments to map)))
      (#t (_map a '())))))

