; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; <=

; ---conformance---
; R5RS

; ---purpose---
; Check whether two or more numbers are in non-ascending order.
; Return #T, if A<=B<=... and otherwise #F.

; ---args---
; A - number
; B... - numbers

; ---keywords---
; <= function, not greater than, less than or equal to,
; ordering, relation, comparison, predicate

; ---see-also---
; digits, <, >, >=, n<=

; ---example---
; (<= 9 9 10) => #t

(define lteq #t)

:require greater.l >
:require iterate.l
:require neqp.l neq?

; ---code---
(define (<= a . b)
  (letrec
    ((lteq (lambda (a b)
      (cond ((eq? a #t) #t)
        ((> a b) #t)
        (#t b)))))
    (cond ((null? b)
        (bottom '(too few arguments to <=)))
      (#t (neq? (iterate lteq (cons a b) #f)
                #t)))))

