; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; list?

; ---conformance---
; R5RS

; ---purpose---
; Check whether an expression is a (proper) list.
; Proper lists are:
; -
; NIL, cons[X;NIL], cons[Y;cons[X;NIL]], etc.

; ---args---
; X - expression

; ---keywords---
; LIST? function, atom, non-atom, list, pair

; ---see-also---
; boolean?, null?

; ---example---
; (list? '(a b c)) => #t

(define listp #t)

; ---code---
(define (list? x)
  (cond ((null? x) #t)
    (#t (and (pair? x) (list? (cdr x))))))

