; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; list-tail

; ---conformance---
; R5RS

; ---purpose---
; Extract the tail of a list beginning at the n'th
; member of that list. The first element is at
; position 0.

; ---args---
; X - list
; N - position of tail to extract

; ---keywords---
; LIST-TAIL function, list, tail, n'th member, position

; ---see-also---
; caar, append, list-ref

; ---example---
; (list-tail '(a b c d e f) 3) => (d e f)

(define list-tail #t)

:require list.l
:require zerop.l zero?

; ---code---
(define (list-tail x n)
  (cond ((zero? n) x)
    ((null? x) (bottom (list 'list-tail x n)))
    (#t (list-tail (cdr x) (n- n 1)))))

