; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; list-ref

; ---conformance---
; R5RS

; ---purpose---
; Extract the n'th member of a list. The first element is at
; position 0.

; ---args---
; X - list
; N - position of member to extract

; ---keywords---
; LIST-REF function, list, n'th member, position

; ---see-also---
; caar, append, list-tail

; ---example---
; (list-ref '(a b c d e f) 2) => c

(define list-ref #t)

:require list-tail.l

; ---code---
(define (list-ref x n)
  (car (list-tail x n)))

