; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; <

; ---conformance---
; R5RS

; ---purpose---
; Check whether two or more numbers are in ascending
; order. Return #T, if A<B<... and otherwise #F.

; ---args---
; A - number
; B... - numbers

; ---keywords---
; < function, less than, ordering, relation
; comparison, predicate, integer

; ---see-also---
; digits, >, <=, >=, n<

; ---example---
; (< -123 0) => #t

(define less #t)

:require abs.l
:require integer.l
:require negativep.l negative?
:require non-negativep.l non-negative?
:require iterate.l
:require neqp.l neq?

; ---code---
(define (< a . b)
  (letrec

    ; Check whether A has less members than B
    ((shorter-list (lambda (a b)
      (cond ((null? a)
          (cond ((null? b) #f)
            (#t #t)))
        ((null? b) #f)
        (#t (shorter-list (cdr a) (cdr b))))))

    (shorter (lambda (a b)
      (shorter-list (integer->list a)
        (integer->list b))))

    ; Check whether A has more members than B
    (longer (lambda (a b)
      (shorter b a)))

    ; Handle signs and lengths
    (compare (lambda (a b)
      (cond ((negative? a)
        (cond ((non-negative? b) #t)
          ((shorter a b) #f)
          ((longer a b) #t)
          (#t (n< (abs b) (abs a)))))
      ((negative? b) #f)
      ((shorter a b) #t)
      ((longer a b) #f)
      (#t (n< (abs a) (abs b))))))

    (lt (lambda (a b)
      (cond ((eq? a #t) #t)
        ((compare (integer a) (integer b)) b)
        (#t #t)))))

    (cond ((null? b)
        (bottom '(too few arguments to <)))
      (#t (neq? (iterate lt (cons a b) #f)
                #t)))))

