; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; length

; ---conformance---
; R5RS

; ---purpose---
; Compute the length of a list. The result is a
; natural number.

; ---args---
; X - list

; ---keywords---
; LENGTH function, lists, length

; ---see-also---
; digits, append, list-tail

; ---example---
; (length '(a b c d e f)) => 6

(define length #t)

; ---model---
; (define (length x)
;   (cond ((null? x) 0)
;     (#t (n+ (length (cdr x)) 1))))

; ---code---
(define (length x)
  (letrec
    ((_length (lambda (x r)
      (cond ((null? x) r)
        (#t (_length (cdr x) (n+ r 1)))))))
    (_length x 0)))

