; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; lcm

; ---conformance---
; R5RS

; ---purpose---
; Compute the least common multiple (LCM) of two integer numbers.

; ---args---
; A - number
; B - number

; ---keywords---
; LCM function, lcm, least common multiple, arithmetics

; ---see-also---
; digits, expt, gcd

; ---example---
; (lcm 32 -36) => 288

(define lcm #t)

:require abs.l
:require gcd.l
:require nquotient.l
:require ntimes.l n*
:require natural.l

; ---code---
(define (lcm . a)
  (letrec
    ((_lcm (lambda (a b)
      (let ((cd (gcd a b)))
        (n* cd
          (n* (nquotient a cd)
            (nquotient b cd)))))))
      (iterate _lcm
        (map (lambda (x)
              (natural (abs x)))
          a)
        1)))

