; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; iterate

; ---conformance---
; Sketchy Core

; ---purpose---
; Iterate through a list. Combine the first member
; of the list with the second member, the result
; with the third member, etc. When the given list
; is empty, return a default.

; ---args---
; F - combining function
; A - list to iterate through
; DEFAULT - expr to return when A=()

; ---keywords---
; ITERATE function, iteration

; ---see-also---
; map

; ---example---
; :l lib/minus.l -
; (iterate - '(1 2 3 4) #f) => -8

(define iterate #t)

; ---code---
(define (iterate f a default)
  (letrec
    ((_iterate (lambda (a res)
      (cond ((null? a) res)
        (#t (_iterate (cdr a)
              (f res (car a))))))))
    (cond ((null? a) default)
      (#t (_iterate (cdr a) (car a))))))

