; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; integer

; ---conformance---
; Sketchy Core

; ---purpose---
; Convert a natural or integer number to an integer.

; ---args---
; A - number

; ---keywords---
; INTEGER function, numbers, digit, integer, conversion

; ---see-also---
; digits, natural

; ---example---
; (integer 567) => +567

(define integer #t)

:require digits.l

; ---code---
(define (integer a)
  (letrec
    ((_integer (lambda (a)
      (cond ((eq? (car a) '+) a)
        ((eq? (car a) '-) a)
        (#t (cons '+ a))))))
    (list->integer
      (_integer (integer->list a)) #t)))

