; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; >=

; ---conformance---
; R5RS

; ---purpose---
; Check whether two or more numbers are in non-ascending order.
; Return #T, if A>=B>=... and otherwise #F.

; ---args---
; A - number
; B... - numbers

; ---keywords---
; >= function, not less than, greater than or equal to,
; ordering, relation, comparison, predicate

; ---see-also---
; digits, <, >, <=, n>=

; ---example---
; (>= 4 4 3) => #t

(define gteq #t)

:require less.l <
:require iterate.l
:require neqp.l neq?

; ---code---
(define (>= a . b)
  (letrec
    ((gteq (lambda (a b)
      (cond ((eq? a #t) #t)
        ((< a b) #t)
        (#t b)))))
    (cond ((null? b)
        (bottom '(too few arguments to >=)))
      (#t (neq? (iterate gteq (cons a b) #f)
                #t)))))

