; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; >

; ---conformance---
; R5RS

; ---purpose---
; Check whether two or more numbers are in descending
; order. Return #T, if A>B>... and otherwise #F.

; ---args---
; A - number
; B... - numbers

; ---keywords---
; > function, greater than, ordering
; relation, comparison, predicate

; ---see-also---
; digits, <, <=, >=, n>

; ---example---
; (> 7 5 3) => #t

(define greater #t)

:require less.l <
:require iterate.l
:require neqp.l neq?

; ---code---
(define (> a . b)
  (letrec
    ((gt (lambda (a b)
      (cond ((eq? a #t) #t)
        ((< b a) b)
        (#t #t)))))
    (cond ((null? b)
        (bottom '(too few arguments to >)))
      (#t (neq? (iterate gt (cons a b) #f)
                #t)))))

