; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; gcd

; ---conformance---
; R5RS

; ---purpose---
; Compute the greatest common divisor (GCD) of two integer numbers.
; This function uses Euclid's Algorithm.

; ---args---
; A - number
; B - number

; ---keywords---
; GCD function, gcd, greatest common divisor
; Euclid, Euclid's algorithm, arithmetics

; ---see-also---
; digits, expt, lcm

; ---example---
; (gcd 99 -77) => 11

(define gcd #t)

:require abs.l
:require natural.l
:require zerop.l zero?
:require nremainder.l
:require map.l

; ---code---
(define (gcd . a)
  (letrec
    ((_gcd (lambda (a b)
      (cond ((zero? b) a)
        ((n< a b) (_gcd a (nremainder b a)))
        (#t (_gcd b (nremainder a b)))))))
    (iterate _gcd
      (map (lambda (x)
            (natural (abs x)))
        a)
      0)))

