; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; expt

; ---conformance---
; R5RS

; ---purpose---
; Compute the X raised to the power of Y.
; X may be a natural or integer number.
; Y must be natural.

; ---args---
; X - number (base)
; Y - number (exponent)

; ---keywords---
; EXPT function, base, exponent, power

; ---see-also---
; digits, sqrt, gcd

; ---example---
; (expt 2 5) => 32

(define expt #t)

:require digits.l
:require negativep.l negative?
:require abs.l
:require zerop.l zero?
:require evenp.l even?
:require times.l *
:require divide.l
:require nquotient.l
:require quotient.l
:require integer.l

; ---model---
; (define (expt x y)
;   (letrec
;     ((exp (lambda (x y r)
;       (cond ((zero? y) r)
;         (#t (exp x (- y 1) (* x r)))))))
;     (exp (integer x) (natural y) 1)))

; ---code---
(define (expt x y)
  (letrec
    ((square (lambda (x)
      (* x x)))
    (_expt (lambda (x y)
      (cond ((zero? y) 1)
        ((even? y)
          (square (_expt x (nquotient y 2))))
        (#t (* x (square (_expt x (nquotient y 2)))))))))
    (_expt (integer x) (natural y))))

