; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; even?

; ---conformance---
; R5RS

; ---purpose---
; Test a number N for being even (N modulo 2 = 0)

; ---args---
; X - number

; ---keywords---
; EVEN? function, even, odd, numbers, digit, predicate

; ---see-also---
; digits, odd?, zero?

; ---example---
; (even? 2) => #t

(define evenp #t)

:require digits.l
:require reverse.l
:require not.l
:require memq.l
;require zerop.l zero?
;require remainder.l

; ---model---
; (define (even? x)
;   (zero? (remainder x 2)))

; ---code---
(define (even? x)
  (not (eq? (memq
              (car (reverse (integer->list x)))
              (integer->list 02468))
         #f)))

