; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; equal?

; ---conformance---
; R5RS

; ---purpose---
; Compare two S-expressions. Return #T,
; if both expressions print equal.

; ---args---
; A - expression
; B - expression

; ---keywords---
; EQUAL function, equivalence, relation, comparison, predicate

; ---see-also---
; member, =

; ---example---
; (equal? '(a b (c d (e)) f) '(a b (c d (e)) f)) => #t

(define equalp #t)

:require equal.l =
:require seqp.l string=?

; ---code---
(define (equal? a b)
  (cond ((number? a)
      (and (number? b) (= a b)))
    ((char? a)
      (and (char? b) (char=? a b)))
    ((string? a)
      (and (string? b) (string=? a b)))
    ((and (pair? a) (pair? b))
      (and (equal? (car a) (car b))
           (equal? (cdr a) (cdr b))))
; This is actually caught by eq?
;     ((or (procedure? a) (procedure? b))
;       (bottom))
    (#t (eq? a b))))

