; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; =

; ---conformance---
; R5RS

; ---purpose---
; Check whether two or more numbers are equal.
; Return #T, if A=B... and otherwise #F.

; ---args---
; A - number
; B... - numbers

; ---keywords---
; = function, equivalence, relation, comparison, predicate

; ---see-also---
; <, >, <=, >=, equal?, not

; ---example---
; (= 123 123 123) => #t

(define equal #t)

:require equalp.l equal?
:require iterate.l
:require normalize.l
:require neqp.l neq?

; ---code---
(define (= a . b)
  (letrec
    ((eq (lambda (a b)
      (cond ((eq? a #t) #t)
        ((equal? (integer->list (normalize a))
          (integer->list (normalize b)))
            a)
        (#t #t)))))
    (cond ((null? b)
        (bottom '(too few arguments to =)))
      (#t (neq? (iterate eq (cons a b) #f) #t)))))

