; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; divide

; ---conformance---
; Sketchy Core

; ---purpose---
; Divide two numbers, giving a result
; of the form (quotient remainder).

; ---args---
; A - number (dividend)
; B - number (divisor)

; ---keywords---
; DIVIDE function, quotient, modulus, division, divide
; arithmetics

; ---see-also---
; digits, quotient, remainder, modulo, +, -, *, ndivide

; ---example---
; (divide 11 -2) => (-5 1)

(define divide #t)

:require digits.l
:require list.l
:require abs.l
:require zerop.l zero?
:require caar.l cadr
:require ndivide.l
:require integer.l
:require negativep.l negative?

; ---code---
(define (divide a b)
  (letrec

    ((sign (lambda (x)
      (cond ((eq? (negative? a) (negative? b)) x)
        (#t (list->integer
              (cons '- (integer->list x)) #t)))))

    (rsign (lambda (x)
      (cond ((negative? a)
          (list->integer
            (cons '- (integer->list x)) #t))
        (#t x))))

    (idiv (lambda (a b)
      (cond ((zero? b) (bottom 'divide-by-zero))
        ; overflow?
        ((n< (abs a) (abs b))
          (list 0 (rsign (abs a))))
        ; compute quotient, remainder
        (#t
          (let ((q (ndivide (abs a) (abs b))))
            (list (sign (car q))
              (rsign (cadr q)))))))))

    (idiv (integer a) (integer b))))

