; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; char>?

; ---conformance---
; R5RS

; ---purpose---
; Test whether two chars are in lexically descending order.

; ---args---
; X - char
; Y - char

; ---keywords---
; CHAR>? function, chars, characters, comparison
; lexical order, descending

; ---see-also---
; char-ci>?, char<?, char=?, char<=?, char>=?, string>?, equal?

; ---example---
; (char>? #\b #\a) => #t

(define cgtp #t)

;require cltp.l char<?

; ---code---
(define (char>? x y)
  (char<? y x))

