; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; char>=?

; ---conformance---
; R5RS

; ---purpose---
; Test whether two chars are in lexically non-ascending order.

; ---args---
; X - char
; Y - char

; ---keywords---
; CHAR>=? function, chars, characters, comparison
; lexical order, non-ascending

; ---see-also---
; char-ci>=?, char<?, char=?, char>?, char<=?, string>=?, equal?

; ---example---
; (char>=? #\b #\b) => #t

(define cgep #t)

:require not.l

; ---code---
(define (char>=? x y)
  (eq? (char<? x y) #f))

