; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; caar ... cddr

; ---conformance---
; R5RS

; ---purpose---
; Access elements of nested lists.

; ---args---
; X - list

; ---keywords---
; CAAR, CADR, CDAR, CDDR
; lists, selector, decomposition

; ---see-also---
; caaaar, caaar

; ---example---
; (cadr '(a b c d e f g h)) => b

(define caar #t)

; ---code---
(define (caar x) (car (car x)))
(define (cadr x) (car (cdr x)))
(define (cdar x) (cdr (car x)))
(define (cddr x) (cdr (cdr x)))
