; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; caaar ... cdddr

; ---conformance---
; R5RS

; ---purpose---
; Access elements of nested lists.

; ---args---
; X - list

; ---keywords---
; CAAAR, CAADR, CADAR, CADDR
; CDAAR, CDADR, CDDAR, CDDDR
; lists, selector, decomposition

; ---see-also---
; caaaar, caar

; ---example---
; (caddr '(a b c d e f g h)) => c

(define caaar #t)

; ---code---
(define (caaar x) (car (car (car x))))
(define (caadr x) (car (car (cdr x))))
(define (cadar x) (car (cdr (car x))))
(define (caddr x) (car (cdr (cdr x))))
(define (cdaar x) (cdr (car (car x))))
(define (cdadr x) (cdr (car (cdr x))))
(define (cddar x) (cdr (cdr (car x))))
(define (cdddr x) (cdr (cdr (cdr x))))

