; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; caaaar ... cddddr

; ---conformance---
; R5RS

; ---purpose---
; Access elements of nested lists.

; ---args---
; X - list

; ---keywords---
; CAAAAR, CAAADR, CAADAR, CAADDR
; CAADAR, CADADR, CADDAR, CADDDR
; CDAAAR, CDAADR, CDADAR, CDADDR
; CDDAAR, CDDADR, CDDDAR, CDDDDR
; lists, selector, decomposition

; ---see-also---
; caaar, caar

; ---example---
; (cadddr '(a b c d e f g h)) => d

(define caaaar #t)

; ---code---
(define (caaaar x) (car (car (car (car x)))))
(define (caaadr x) (car (car (car (cdr x)))))
(define (caadar x) (car (car (cdr (car x)))))
(define (caaddr x) (car (car (cdr (cdr x)))))
(define (cadaar x) (car (cdr (car (car x)))))
(define (cadadr x) (car (cdr (car (cdr x)))))
(define (caddar x) (car (cdr (cdr (car x)))))
(define (cadddr x) (car (cdr (cdr (cdr x)))))
(define (cdaaar x) (cdr (car (car (car x)))))
(define (cdaadr x) (cdr (car (car (cdr x)))))
(define (cdadar x) (cdr (car (cdr (car x)))))
(define (cdaddr x) (cdr (car (cdr (cdr x)))))
(define (cddaar x) (cdr (cdr (car (car x)))))
(define (cddadr x) (cdr (cdr (car (cdr x)))))
(define (cdddar x) (cdr (cdr (cdr (car x)))))
(define (cddddr x) (cdr (cdr (cdr (cdr x)))))

