; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; char-whitespace?

; ---conformance---
; R5RS

; ---purpose---
; Test whether a char is white space.

; ---args---
; X - char

; ---keywords---
; CHAR-WHITESPACE? function, chars, characters, property, case

; ---see-also---
; char-lower-case?, char-alphabetic?, char-numeric?

; ---example---
; (char-whitespace? #\space) => #t

(define c-whitespacep #t)

; ---code---
(define (char-whitespace? x)
  (or (char=? x #\space)
      (char=? x #\newline)
      (char=? x (integer->char 9))  ; HT
      (char=? x (integer->char 12)) ; FF
      (char=? x (integer->char 13)))) ; CR

