; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; char-upper-case?

; ---conformance---
; R5RS

; ---purpose---
; Test whether a char is an upper case character.

; ---args---
; X - char

; ---keywords---
; CHAR-UPPER-CASE? function, chars, characters, property, case

; ---see-also---
; char-lower-case?, char-alphabetic?

; ---example---
; (char-upper-case? #\X) => #t

(define c-upper-casep #t)

:require clep.l char<=?

; ---code---
(define (char-upper-case? x)
  (and (char<=? #\A x)
       (char<=? x #\Z)))

