; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; char-upcase

; ---conformance---
; R5RS

; ---purpose---
; Convert a char to upper case.

; ---args---
; X - char

; ---keywords---
; CHAR-UPCASE function, chars, characters, case, conversion

; ---see-also---
; char-downcase, char-upper-case?, char-alphabetic?

; ---example---
; (char-upcase #\x) => #\X

(define c-upcase #t)

:require c-lower-casep.l char-lower-case?
:require minus.l -

; ---code---
(define (char-upcase x)
  (cond ((char-lower-case? x)
      (integer->char (- (char->integer x) 32)))
    (#t x)))

