; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; char-numeric?

; ---conformance---
; R5RS

; ---purpose---
; Test whether a char is numeric.

; ---args---
; X - char

; ---keywords---
; CHAR-NUMERIC? function, chars, characters, property, case

; ---see-also---
; char-lower-case?, char-alphabetic?, char-whitespace?

; ---example---
; (char-numeric? #\5) => #t

(define c-numericp #t)

:require clep.l char<=?

; ---code---
(define (char-numeric? x)
  (and (char<=? #\0 x)
       (char<=? x #\9)))

