; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; char-lower-case?

; ---conformance---
; R5RS

; ---purpose---
; Test whether a char is a lower case character.

; ---args---
; X - char

; ---keywords---
; CHAR-LOWER-CASE? function, chars, characters, property, case

; ---see-also---
; char-upper-case?, char-alphabetic?

; ---example---
; (char-lower-case? #\z) => #t

(define c-lower-casep #t)

:require clep.l char<=?

; ---code---
(define (char-lower-case? x)
  (and (char<=? #\a x)
       (char<=? x #\z)))

