; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; char-downcase

; ---conformance---
; R5RS

; ---purpose---
; Convert a char to lower case.

; ---args---
; X - char

; ---keywords---
; CHAR-DOWNCASE function, chars, characters, case, conversion

; ---see-also---
; char-upcase, char-lower-case?, char-alphabetic?

; ---example---
; (char-downcase #\X) => #\x

(define c-downcase #t)

:require c-upper-casep.l char-upper-case?
:require plus.l +

; ---code---
(define (char-downcase x)
  (cond ((char-upper-case? x)
      (integer->char (+ (char->integer x) 32)))
    (#t x)))

