; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; char-ci<?

; ---conformance---
; R5RS

; ---purpose---
; Case-insensitively test whether two chars are in
; lexically ascending order.

; ---args---
; X - char
; Y - char

; ---keywords---
; CHAR-CI<? function, chars, characters, comparison,
; lexical order, ascending, case insensitive

; ---see-also---
; char<?, char-ci=?, char-ci>?, char-ci<=?, char-ci>=?, string<?, equal?

; ---example---
; (char-ci<? #\a #\B) => #t

(define c-ciltp #t)

;require c-downcase.l char-downcase
;require less.l <

; ---model---
; (define char-ci<? (lambda (x y)
;   (< (char->integer (char-downcase x))
;      (char->integer (char-downcase y)))))

; ---code---
; This function is a primitive function.

