; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; char-ci<=?

; ---conformance---
; R5RS

; ---purpose---
; Case-insensitively test whether two chars are in
; lexically non-descending order.

; ---args---
; X - char
; Y - char

; ---keywords---
; CHAR-CI<=? function, chars, characters, comparison,
; lexical order, non-descending, case insensitive

; ---see-also---
; char<=?, char-ci<?, char-ci=?, char-ci>?, char-ci>=?, string<=?, equal?

; ---example---
; (char-ci<=? #\b #\B) => #t

(define c-cilep #t)

:require c-cigtp.l char-ci>?
:require not.l

; ---code---
(define (char-ci<=? x y)
  (eq? (char-ci>? x y) #f))

