; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; char-ci>?

; ---conformance---
; R5RS

; ---purpose---
; Case-insensitively test whether two chars are in
; lexically descending order.

; ---args---
; X - char
; Y - char

; ---keywords---
; CHAR-CI>? function, chars, characters, comparison,
; lexical order, descending, case insensitive

; ---see-also---
; char>?, char-ci<?, char-ci=?, char-ci<=?, char-ci>=?, string>?, equal?

; ---example---
; (char-ci>? #\B #\a) => #t

(define c-cigtp #t)

;require c-ciltp.l char-ci<?

; ---code---
(define (char-ci>? x y)
  (char-ci<? y x))

