; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; char-ci=?

; ---conformance---
; R5RS

; ---purpose---
; Case-insensitively test whether two chars are equal.

; ---args---
; X - char
; Y - char

; ---keywords---
; CHAR-CI=? function, chars, characters, comparison, equivalence,
; lexical equivalence, case insensitive

; ---see-also---
; char=?, char-ci<?, char-ci>?, char-ci<=?, char-ci>=?, string=?, equal?

; ---example---
; (char-ci=? #\C #\c) => #t

(define c-cieqp #t)

;require c-downcase.l char-downcase
;require equal.l =

; ---model---
; (define char-ci=? (lambda (x y)
;   (= (char->integer (char-downcase x))
;      (char->integer (char-downcase y)))))

; ---code---
; This function is a primitive function.

