; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; char-alphabetic?

; ---conformance---
; R5RS

; ---purpose---
; Test whether a char is alphabetic.

; ---args---
; X - char

; ---keywords---
; CHAR-ALPHABETIC? function, chars, characters, property, case

; ---see-also---
; char-lower-case?, char-numeric?, char-whitespace?

; ---example---
; (char-alphabetic? #\c) => #t

(define c-alphabeticp #t)

:require c-upper-casep.l char-upper-case?
:require c-lower-casep.l char-lower-case?

; ---code---
(define (char-alphabetic? x)
  (or (char-lower-case? x)
      (char-upper-case? x)))

