; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; boolean?

; ---conformance---
; R5RS

; ---purpose---
; Check whether an expression X is a truth value.
; Return #T for X=#T and X=#F and otherwise #F.

; ---args---
; X - expression

; ---keywords---
; BOOLEAN? function, boolean, truth value, true, false
; predicate

; ---see-also---
; list?, null?

; ---example---
; (boolean? #f) => #t

(define booleanp #t)

; ---code---
(define (boolean? x)
  (or (eq? x #t)
      (eq? x #f)))

