; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; assoc

; ---conformance---
; R5RS

; ---purpose---
; Retrieve a binding from an association list.
; An association list is a list of pairs where
; the CAR part of each pair holds a key and
; the CDR part of the pair holds the value
; associated with that key:
; -
; ((key1.value1) ... (keyN.valueN))

; ---args---
; X - key of value to be found
; A - association list

; ---keywords---
; ASSOC function, association lists, alists, associate

; ---see-also---
; member, assq

; ---example---
; (assoc '3 '((1.i) (2.ii) (3.iii) (4.iv))) => (3 . iii)

(define assoc #t)

:require equalp.l equal?
:require caar.l cdar

; ---model---
; (define (assoc x a)
;   (cond ((null? a) #f)
;     ((equal? (caar a) x) (car a))
;     (#t (assoc x (cdr a)))))

; ---code---
(define (assoc x a)
  (letrec
    ((_assoc (lambda (a)
      (cond ((null? a) #f)
        ((equal? (caar a) x) (car a))
        (#t (_assoc (cdr a)))))))
    (_assoc a)))

