; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; append

; ---conformance---
; R5RS

; ---purpose---
; Append lists. The last argument to append may be an atom,
; resulting in an improper list.

; ---args---
; A... - lists

; ---keywords---
; APPEND function, lists, appending

; ---see-also---
; reverse, length, map, equal?, list?

; ---example---
; (append '(a b) '(c d) '(e f)) => (a b c d e f)

(define append #t)

:require reverse.l
:require iterate.l

; ---code---
(define (append . a)
  (letrec
    ((append2 (lambda (a b)
      (cond ((null? a) b)
        (#t (append2 (cdr a) (cons (car a) b))))))
    (_append (lambda (a b)
      (cond ((null? b) a)
        (#t (append2 (reverse a) b))))))
    (iterate _append a '())))

