; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; abs

; ---conformance---
; R5RS

; ---purpose---
; Compute the absolute value of a number.

; ---args---
; X - number

; ---keywords---
; ABS function, absolute value, arithmetics

; ---see-also---
; digits, -, negative?

; ---example---
; (abs -125) => 125

(define abs #t)

:require digits.l

; ---code---
(define (abs x)
  (letrec
    ((_abs (lambda (x)
      (cond ((eq? (car x) '-) (cdr x))
        ((eq? (car x) '+) (cdr x))
        (#t x)))))
    (list->integer (_abs (integer->list x)) #t)))

