#include "\code\stdio.h"

/***  XYZZY XYZZY XYZZY XYZZY XYZZY XYZZY XYZZY XYZZY XYZZY  ***
 ***  the quick brown foxy prince jumped over the lazy CGA   ***
 ***  1234567890  1234567890  1234567890  1234567890  12345  ***/


/* calling convention: 
 *  - last arg is word at [bp+4]
 *  - next to last arg is word at [bp+6]
 *  - etc.
 * need to preserve BX (but can trash AX)
 */

setCRTC(idx,val) int idx, val; {
        #asm
        CLI
        MOV     DX, 03D4h
        MOV     AL, [BP+6]
        OUT     DX, AL
        INC     DX
        MOV     AL, [BP+4]
        OUT     DX, AL
        STI
        #endasm
}

/* 0=200 lines, 1=350 lines, 2=400 lines */
vgalines(ln) int ln; {
        #asm
        CLI
        PUSH    BX
        MOV     AH, 12h
        MOV     AL, [BP+4]
        MOV     BL, 30h
        INT     10h
        MOV     AX, 0003h               ; mode 03h (80x25 text)
        INT     10h
        POP     BX
        STI
        #endasm
}

xsetborder(colour) int colour; {
        #asm
        CLI
        MOV     DX, 03C0h
        IN      AL, DX
        MOV     AL, 31h
        OUT     DX, AL
        MOV     AL, [BP+4]
        OUT     DX, AL
        STI
        #endasm
}

setborder(colour) int colour; {
        #asm
        PUSH    BX
        MOV     AX, 1001h
        MOV     BH, [BP+4]
        INT     10h
        POP     BX
        #endasm
}

setcur(start,end) int start, end; {
        #asm
        PUSH    BX
        MOV     AX, 0100h
        MOV     CH, [BP+6]
        MOV     CL, [BP+4]
        INT     10h
        POP     BX
        #endasm
}

setfont(buf,height) int *buf, height; {
        #asm
        PUSH    BX
        PUSH    ES
        PUSH    BP
        MOV     AX, DS
        MOV     ES, AX
        MOV     AX, 1100h
        MOV     BL, 0
        MOV     BH, [BP+4]      ; bytes/char
        MOV     CX, 100h        ; char count
        MOV     DX, 0
        MOV     BP, [BP+6]      ; buffer address
        INT     10h
        POP     BP
        POP     ES
        POP     BX
        #endasm
}

int crtctab1[] = {
        0x11, 0x07,     /* CR11 (VSYNC END) - unprotect CRTC regs       */
        0x06, 0x66,     /* CR06 (V TOTAL):  0x166 = 358+2               */
        0x07, 0x1F,     /* CR07 (OVERFLOW)                              */
        0x09, 0x4B,     /* CR09 (CHAR HEIGHT)                           */
        0x0A, 0x0A,     /* CR0A (TEXT CURSOR START)                     */
        0x0B, 0x0B,     /* CR0B (TEXT CURSOR END)                       */
        0x10, 0x44,     /* CR10 (VSYNC START)                           */
        0x11, 0x87,     /* CR11 (VSYNC END) - reprotect CRTC regs       */
        0x12, 0x37,     /* CR12 (VDISP END)                             */
        0x15, 0x3F,     /* CR15 (VBLANK START)                          */
        0x16, 0x64,     /* CR16 (VBLANK END)                            */
        0xFF, 0xFF      /* --END-- */
};

int crtctab2[] = {
        0x11, 0x07,     /* CR11 (VSYNC END) - unprotect CRTC regs       */
        0x06, 0x66,     /* CR06 (V TOTAL):  0x166 = 358+2               */
        0x07, 0x1F,     /* CR07 (OVERFLOW)                              */
        0x09, 0x4A,     /* CR09 (CHAR HEIGHT)                           */
        0x0A, 0x09,     /* CR0A (TEXT CURSOR START)                     */
        0x0B, 0x0A,     /* CR0B (TEXT CURSOR END)                       */
        0x10, 0x44,     /* CR10 (VSYNC START)                           */
        0x11, 0x87,     /* CR11 (VSYNC END) - reprotect CRTC regs       */
        0x12, 0x13,     /* CR12 (VDISP END)                             */
        0x15, 0x3F,     /* CR15 (VBLANK START)                          */
        0x16, 0x64,     /* CR16 (VBLANK END)                            */
        0xFF, 0xFF      /* --END-- */
};

/* 640x275 (656x286 with border) */
int crtctab3[] = {
        0x11, 0x0E,     /* CR11 (VSYNC END) - unprotect CRTC regs       */
        0x06, 0x5C,     /* CR06 (V TOTAL)                               */
        0x07, 0x1F,     /* CR07 (OVERFLOW)                              */
        0x09, 0x4A,     /* CR09 (CHAR HEIGHT)                           */
        0x0A, 0x07,     /* CR0A (TEXT CURSOR START)                     */
        0x0B, 0x08,     /* CR0B (TEXT CURSOR END)                       */
        0x10, 0x3B,     /* CR10 (VSYNC START)                           */
        0x11, 0x8E,     /* CR11 (VSYNC END) - reprotect CRTC regs       */
        0x12, 0x12,     /* CR12 (VDISP END)                             */
        0x15, 0x18,     /* CR15 (VBLANK START)                          */
        0x16, 0x58,     /* CR16 (VBLANK END)                            */
        0xFF, 0xFF      /* --END-- */
};

/* 640x300 with 6px top/bottom border and 16px left/right border */
int crtctab4[] = {
        0x11, 0x0F,     /* CR11 (VSYNC END) - unprotect CRTC regs       */
        0x00, 0x5F,     /* CR00 (HTOTAL)                                */
        0x01, 0x4F,     /* CR01 (HDISP)                                 */
        0x02, 0x51,
        0x03, 0x81,
        0x04, 0x55,
        0x05, 0x81,
        0x06, 0x5C,
        0x07, 0x1F,
        0x09, 0x4B,
        0x10, 0x3C,
        0x11, 0x8F,
        0x12, 0x2B,
        0x15, 0x31,
        0x16, 0x57,
        0xFF, 0xFF      /* --END -- */
};

#define CRTCTAB crtctab4
#define FONTNAME "VGA12.FON"
#define FONTSZ   12

main(argc,argv) int argc, argv[]; {
        int i, cridx, crdat;
        int f;
        int *buf;

        /* set 640x350 text mode */
        vgalines(1);

        /* load the font */
        f = fopen(FONTNAME, "r");
        if (!f) { printf("Error loading font!\n"); return 1; }
        buf = malloc(256 * FONTSZ);
        fread(buf, 256, FONTSZ, f);
        fclose(f);
        setfont(buf, FONTSZ);

        /* modify the mode */
        for (i=0; CRTCTAB[i] < 0xFF; i += 2) {
                cridx=CRTCTAB[i];
                crdat=CRTCTAB[i+1];
                printf("CR%02x=0x%x\n", cridx, crdat);
                setCRTC(cridx, crdat);
        }
        setborder(3);
        setcur(3,10);


        return 0;
}


