# -----------------------------------------------------------------------------
# APC PowerNet & RFC 1628 UPS Trap Definition File
# -----------------------------------------------------------------------------
# Copyright (c) 2007 American Power Conversion, Inc.
#
# Name : apctraps387.sh
#
# Generated by script: tosh.awk
#
# Input File: powernetPS.mib
#
# Created: Wednesday, January, 03, 2007
#
# Revision History:
# -----------------------------------------------------------------------------
#
# APC PowerNet Traps
#
#
#!/bin/sh

/usr/OV/bin/addtrap -l comtio         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 1   -t 4 -S 4 -c "Status Events" -f - -F "Communication lost between the agent and the UPS. Host: %s."
/usr/OV/bin/addtrap -l upsOverload    -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 2   -t 4 -S 4 -c "Status Events" -f - -F "The UPS has sensed a load greater than 100 percent of its rated capacity. Host: %s."
/usr/OV/bin/addtrap -l upsgnoile      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 3   -t 4 -S 4 -c "Status Events" -f - -F "The UPS has failed its internal self-test. Host: %s."
/usr/OV/bin/addtrap -l upsDischarged  -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 4   -t 4 -S 4 -c "Status Events" -f - -F "The UPS batteries are discharged. Host: %s."
/usr/OV/bin/addtrap -l upsOnBattery   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 5   -t 3 -S 2 -c "Status Events" -f - -F "The UPS has switched to battery backup power. Host: %s."
/usr/OV/bin/addtrap -l smartBoostOn   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 6   -t 3 -S 2 -c "Status Events" -f - -F "The UPS has enabled SmartBoost(TM); low incoming line voltage. Host: %s."
/usr/OV/bin/addtrap -l lowBattery     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 7   -t 4 -S 4 -c "Status Events" -f - -F "The UPS system's batteries are low and will soon be exhausted. Host: %s."
/usr/OV/bin/addtrap -l comtiobli      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 8   -t 2 -S 0 -c "Status Events" -f - -F "UPS communication has been established. Host: %s."
/usr/OV/bin/addtrap -l powerRestored  -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 9   -t 2 -S 0 -c "Status Events" -f - -F "Returned from battery backup power; utility power restored. Host: %s."
/usr/OV/bin/addtrap -l upsgnosse      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 10  -t 2 -S 0 -c "Status Events" -f - -F "The UPS passed internal self-test. Host: %s."
/usr/OV/bin/addtrap -l rettte         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 11  -t 2 -S 0 -c "Status Events" -f - -F "The UPS has returned from a Low-Battery condition. Host: %s."
/usr/OV/bin/addtrap -l upsTurnedOff   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 12  -t 3 -S 2 -c "Status Events" -f - -F "The UPS has been switched off by a management station. Host: %s."
/usr/OV/bin/addtrap -l upsSleeping    -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 13  -t 3 -S 2 -c "Status Events" -f - -F "The UPS entered sleep mode. Power to the load will be cut off. Host: %s."
/usr/OV/bin/addtrap -l upsWokeUp      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 14  -t 2 -S 0 -c "Status Events" -f - -F "The UPS has returned from sleep mode. Power to the load has been restored. Host: %s."
/usr/OV/bin/addtrap -l upsrte         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 15  -t 3 -S 2 -c "Status Events" -f - -F "The UPS has started its reboot sequence. Host: %s."
/usr/OV/bin/addtrap -l upsnge         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 16  -t 3 -S 2 -c "Status Events" -f - -F "The DIP switch settings on the UPS have been changed. Host: %s."
/usr/OV/bin/addtrap -l upsttecem      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 17  -t 4 -S 4 -c "Status Events" -f - -F "The UPS batteries require immediate replacement. Host: %s."
/usr/OV/bin/addtrap -l contactFault   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 18  -t 4 -S 4 -c "Status Events" -f - -F "An Environment contact %i closure has faulted. Host: %s."
/usr/OV/bin/addtrap -l conctFult      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 19  -t 2 -S 0 -c "Status Events" -f - -F "A Environment contact %i closure has returned to it's default state. Host: %s."
/usr/OV/bin/addtrap -l harrdwreFiluss -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 20  -t 4 -S 4 -c "Status Events" -f - -F "The UPS is on bypass due to an internal fault. Host: %s."
/usr/OV/bin/addtrap -l softwareBypass -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 21  -t 3 -S 2 -c "Status Events" -f - -F "UPS put on bypass by user via software or front UPS panel. Host: %s."
/usr/OV/bin/addtrap -l switchedBypass -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 22  -t 3 -S 2 -c "Status Events" -f - -F "UPS put on bypass by user. Host: %s."
/usr/OV/bin/addtrap -l retss          -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 23  -t 2 -S 0 -c "Status Events" -f - -F "The UPS has returned from bypass mode. Host: %s."
/usr/OV/bin/addtrap -l bypssPilu      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 24  -t 4 -S 4 -c "Status Events" -f - -F "The base module bypass power supply needs repair. Host: %s."
/usr/OV/bin/addtrap -l baseFanFailure -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 25  -t 4 -S 4 -c "Status Events" -f - -F "The base module fan needs repair. Host: %s."
/usr/OV/bin/addtrap -l battteckC      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 26  -t 4 -S 4 -c "Status Events" -f - -F "Communication lost with external battery packs, check battery signal cable. Host: %s."
/usr/OV/bin/addtrap -l battteckCbli   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 27  -t 2 -S 0 -c "Status Events" -f - -F "Communication established with external battery packs. Host: %s."
/usr/OV/bin/addtrap -l callibtiort    -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 28  -t 2 -S 0 -c "Status Events" -f - -F "A battery run time calibration test has been initiated. Host: %s."
/usr/OV/bin/addtrap -l restartAgent   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 29  -t 2 -S 0 -c "Status Events" -f - -F "Agent restarting as commanded by manager. Host: %s."
/usr/OV/bin/addtrap -l upsTurnedOn    -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 30  -t 2 -S 0 -c "Status Events" -f - -F "A UPS is turned on. Host: %s."
/usr/OV/bin/addtrap -l smartA         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 31  -t 3 -S 2 -c "Status Events" -f - -F "The UPS has enabled SmartTrim(TM) voltage reduction. Host: %s."
/usr/OV/bin/addtrap -l codtio         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 32  -t 2 -S 0 -c "Status Events" -f - -F "Authentication on agent code image is done. Host: %s."
/usr/OV/bin/addtrap -l upsdClred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 33  -t 2 -S 0 -c "Status Events" -f - -F "The overload condition has been cleared. . Host: %s."
/usr/OV/bin/addtrap -l smartBoostOff  -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 34  -t 2 -S 0 -c "Status Events" -f - -F "The UPS has returned from SmartBoost(TM). Host: %s."
/usr/OV/bin/addtrap -l smartA         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 35  -t 2 -S 0 -c "Status Events" -f - -F "The UPS has returned from SmartTrim(TM) voltage reduction. Host: %s."
/usr/OV/bin/addtrap -l upstteced      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 36  -t 2 -S 0 -c "Status Events" -f - -F "The UPS has returned from a bad battery fault. Host: %s."
/usr/OV/bin/addtrap -l calibrationEnd -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 37  -t 2 -S 0 -c "Status Events" -f - -F "The UPS has finished calibrating Host: %s."
/usr/OV/bin/addtrap -l disrgered      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 38  -t 2 -S 0 -c "Status Events" -f - -F "The UPS discharge condition has been cleared. Host: %s."
/usr/OV/bin/addtrap -l gracef         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 39  -t 2 -S 0 -c "Status Events" -f - -F "A graceful shutdown has been initiated. Host: %s."
/usr/OV/bin/addtrap -l outletOn       -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 41  -t 3 -S 2 -c "Status Events" -f - -F "Outlet %i has been turned on Host: %s."
/usr/OV/bin/addtrap -l outletOff      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 42  -t 3 -S 2 -c "Status Events" -f - -F "Outlet %i has turned off. Host: %s."
/usr/OV/bin/addtrap -l outletReboot   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 43  -t 3 -S 2 -c "Status Events" -f - -F "Outlet %i has rebooted. Host: %s."
/usr/OV/bin/addtrap -l connge         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 44  -t 3 -S 2 -c "Status Events" -f - -F "The SNMP configuration has been changed. Host: %s."
/usr/OV/bin/addtrap -l connge         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 45  -t 3 -S 2 -c "Status Events" -f - -F "Outlet %i configuration has been changed. Host: %s."
/usr/OV/bin/addtrap -l accetio        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 46  -t 3 -S 2 -c "Status Events" -f - -F "Three unsuccessful logins have been attempted via the console. Host: %s."
/usr/OV/bin/addtrap -l accetio        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 47  -t 3 -S 2 -c "Status Events" -f - -F "An unsuccessful attempt to login via HTTP. Host: %s."
/usr/OV/bin/addtrap -l passwordChange -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 48  -t 3 -S 2 -c "Status Events" -f - -F "Someone has changed the password on the device. Host: %s."
/usr/OV/bin/addtrap -l badVoltage     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 49  -t 3 -S 2 -c "Status Events" -f - -F "The output voltage is not within acceptable range. Host: %s."
/usr/OV/bin/addtrap -l baddVogeCred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 50  -t 2 -S 0 -c "Status Events" -f - -F "The output voltage has returned to an acceptable level. Host: %s."
/usr/OV/bin/addtrap -l chargerFailure -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 51  -t 3 -S 2 -c "Status Events" -f - -F "The battery charger has failed. Host: %s."
/usr/OV/bin/addtrap -l chargeilured   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 52  -t 2 -S 0 -c "Status Events" -f - -F "The battery charger failure condition has been cleared. Host: %s."
/usr/OV/bin/addtrap -l batttetur      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 53  -t 3 -S 2 -c "Status Events" -f - -F "The battery temperature threshold has been violated. Host: %s."
/usr/OV/bin/addtrap -l battteturred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 54  -t 2 -S 0 -c "Status Events" -f - -F "The battery over temperature has been cleared. Host: %s."
/usr/OV/bin/addtrap -l smartRyFault   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 55  -t 3 -S 2 -c "Status Events" -f - -F "SmartBoost(TM) or SmartTrim(TM) relay fault. Host: %s."
/usr/OV/bin/addtrap -l smartRyFaultre -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 56  -t 2 -S 0 -c "Status Events" -f - -F "SmartBoost(TM) or SmartTrim(TM) relay fault has been cleared. Host: %s."
/usr/OV/bin/addtrap -l humtio1        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 57  -t 4 -S 4 -c "Status Events" -f - -F "A humidity threshold has been violated on probe 1. Humidity is %i percent. Host: %s."
/usr/OV/bin/addtrap -l humtiored1     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 58  -t 2 -S 0 -c "Status Events" -f - -F "A humidity threshold violation has been cleared on probe 1. Host: %s."
/usr/OV/bin/addtrap -l temturtio1     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 59  -t 4 -S 4 -c "Status Events" -f - -F "A temperature threshold has been violated on probe 1. Temperature is %i. Host: %s."
/usr/OV/bin/addtrap -l temturtiored1  -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 60  -t 2 -S 0 -c "Status Events" -f - -F "A temperature threshold violation has been cleared on probe 1. Host: %s."
/usr/OV/bin/addtrap -l humtio2        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 61  -t 4 -S 4 -c "Status Events" -f - -F "A humidity threshold has been violated on probe 2. Humidity is %i percent. Host: %s."
/usr/OV/bin/addtrap -l humtiored2     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 62  -t 2 -S 0 -c "Status Events" -f - -F "A humidity threshold violation has been cleared on probe 2. Host: %s."
/usr/OV/bin/addtrap -l temturtio2     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 63  -t 4 -S 4 -c "Status Events" -f - -F "A temperature threshold has been violated on probe 2. Temperature is %i. Host: %s."
/usr/OV/bin/addtrap -l temturtiored2  -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 64  -t 2 -S 0 -c "Status Events" -f - -F "A temperature threshold violation has been cleared on probe 2. Host: %s."
/usr/OV/bin/addtrap -l muptiobli      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 65  -t 2 -S 0 -c "Status Events" -f - -F "Communication established between the agent and the Environmental Monitor. Host: %s."
/usr/OV/bin/addtrap -l muptio         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 66  -t 4 -S 4 -c "Status Events" -f - -F "Communication lost between the agent and the Environmental Monitor. Host: %s."
/usr/OV/bin/addtrap -l batttese       -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 67  -t 2 -S 0 -c "Status Events" -f - -F "The number of batteries has increased. Host: %s."
/usr/OV/bin/addtrap -l batttese       -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 68  -t 2 -S 0 -c "Status Events" -f - -F "The number of batteries has decreased. Host: %s."
/usr/OV/bin/addtrap -l powse          -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 69  -t 2 -S 0 -c "Status Events" -f - -F "The number of power modules has increased. Host: %s."
/usr/OV/bin/addtrap -l powse          -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 70  -t 2 -S 0 -c "Status Events" -f - -F "The number of power modules has decreased. Host: %s."
/usr/OV/bin/addtrap -l int            -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 71  -t 2 -S 0 -c "Status Events" -f - -F "An intelligence module has been inserted. Host: %s."
/usr/OV/bin/addtrap -l int            -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 72  -t 2 -S 0 -c "Status Events" -f - -F "An intelligence module has been removed. Host: %s."
/usr/OV/bin/addtrap -l rin            -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 73  -t 2 -S 0 -c "Status Events" -f - -F "A redundant intelligence module has been inserted. Host: %s."
/usr/OV/bin/addtrap -l rin            -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 74  -t 2 -S 0 -c "Status Events" -f - -F "A redundant intelligence module has been removed. Host: %s."
/usr/OV/bin/addtrap -l extttemeIse    -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 75  -t 2 -S 0 -c "Status Events" -f - -F "An external battery frame has been added. Host: %s."
/usr/OV/bin/addtrap -l extttemeDse    -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 76  -t 2 -S 0 -c "Status Events" -f - -F "An external battery frame has been removed. Host: %s."
/usr/OV/bin/addtrap -l abnolCo        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 77  -t 4 -S 4 -c "Status Events" -f - -F "APC %s Host: %s."
/usr/OV/bin/addtrap -l abnolCored     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 78  -t 2 -S 0 -c "Status Events" -f - -F "APC %s Host: %s."
/usr/OV/bin/addtrap -l devtusnge      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 79  -t 2 -S 0 -c "Status Events" -f - -F "The status of the device being monitored has changed. Host: %s."
/usr/OV/bin/addtrap -l noBatteries    -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 80  -t 3 -S 2 -c "Status Events" -f - -F "The UPS has no batteries attached. Host: %s."
/usr/OV/bin/addtrap -l noBttered      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 81  -t 2 -S 0 -c "Status Events" -f - -F "The UPS's batteries have been attached. Host: %s."
/usr/OV/bin/addtrap -l userAdded      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 82  -t 2 -S 0 -c "Status Events" -f - -F "A new user has been added. Host: %s."
/usr/OV/bin/addtrap -l userDeleted    -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 83  -t 2 -S 0 -c "Status Events" -f - -F "A user has been deleted. Host: %s."
/usr/OV/bin/addtrap -l userModified   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 84  -t 2 -S 0 -c "Status Events" -f - -F "A user has been modified. Host: %s."
/usr/OV/bin/addtrap -l msvtiobli      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 85  -t 2 -S 0 -c "Status Events" -f - -F "Communications with the MasterSwitch VM has been established. Host: %s."
/usr/OV/bin/addtrap -l msvtio         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 86  -t 4 -S 4 -c "Status Events" -f - -F "Communications with the MasterSwitch VM has been lost. Host: %s."
/usr/OV/bin/addtrap -l msvmOverload   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 87  -t 4 -S 4 -c "Status Events" -f - -F "The MasterSwitch VM is near or at an overload condition. Host: %s."
/usr/OV/bin/addtrap -l msvdClred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 88  -t 2 -S 0 -c "Status Events" -f - -F "The overload condition on the MasterSwitch VM has been cleared. Host: %s."
/usr/OV/bin/addtrap -l msvmOutletOn   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 89  -t 2 -S 0 -c "Status Events" -f - -F "An outlet on the MasterSwitch VM has turned on. Host: %s."
/usr/OV/bin/addtrap -l msvmOutletOff  -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 90  -t 2 -S 0 -c "Status Events" -f - -F "An outlet on the MasterSwitch VM has turned off. Host: %s."
/usr/OV/bin/addtrap -l msvnge         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 91  -t 2 -S 0 -c "Status Events" -f - -F "A device configuration change has been made on a MasterSwitch VM. Host: %s."
/usr/OV/bin/addtrap -l msvnge         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 92  -t 2 -S 0 -c "Status Events" -f - -F "An outlet configuration change has been made on a MasterSwitch VM. Host: %s."
/usr/OV/bin/addtrap -l msvmLowLoad    -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 93  -t 2 -S 0 -c "Status Events" -f - -F "The MasterSwitch VM has violated the low load threshold. Host: %s."
/usr/OV/bin/addtrap -l msvdClred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 94  -t 2 -S 0 -c "Status Events" -f - -F "The low load condition on the MasterSwitch VM has been cleared. Host: %s."
/usr/OV/bin/addtrap -l msvrOvd        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 95  -t 4 -S 4 -c "Status Events" -f - -F "The MasterSwitch VM is near or at an overload condition. Host: %s."
/usr/OV/bin/addtrap -l msvrOvdClred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 96  -t 2 -S 0 -c "Status Events" -f - -F "The overload condition on the MasterSwitch VM has been cleared. Host: %s."
/usr/OV/bin/addtrap -l msvtusnge      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 97  -t 3 -S 2 -c "Status Events" -f - -F "The power supply status of the MasterSwitch VM has changed. Host: %s."
/usr/OV/bin/addtrap -l msptiobli      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 98  -t 2 -S 0 -c "Status Events" -f - -F "Communications with the MasterSwitch plus has been established. Host: %s."
/usr/OV/bin/addtrap -l msptio         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 99  -t 4 -S 4 -c "Status Events" -f - -F "Communications with the MasterSwitch plus has been lost. Host: %s."
/usr/OV/bin/addtrap -l mspOutletOn    -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 100 -t 2 -S 0 -c "Status Events" -f - -F "An outlet on the MasterSwitch plus has turned on. Host: %s."
/usr/OV/bin/addtrap -l mspOutletOff   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 101 -t 2 -S 0 -c "Status Events" -f - -F "An outlet on the MasterSwitch plus has turned off. Host: %s."
/usr/OV/bin/addtrap -l mspnge         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 102 -t 2 -S 0 -c "Status Events" -f - -F "A device configuration change has been made on a MasterSwitch plus. Host: %s."
/usr/OV/bin/addtrap -l mspnge         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 103 -t 2 -S 0 -c "Status Events" -f - -F "An outlet configuration change has been made on a MasterSwitch plus. Host: %s."
/usr/OV/bin/addtrap -l rsS            -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 104 -t 2 -S 0 -c "Status Events" -f - -F "The Redundant Switch has switched source. Host: %s."
/usr/OV/bin/addtrap -l rsLncy         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 105 -t 4 -S 4 -c "Status Events" -f - -F "The Redundant Switch has lost redundancy. Host: %s."
/usr/OV/bin/addtrap -l rsRncy         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 106 -t 2 -S 0 -c "Status Events" -f - -F "Redundancy has been restored to the Redundant Switch . Host: %s."
/usr/OV/bin/addtrap -l rsConfigChange -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 107 -t 2 -S 0 -c "Status Events" -f - -F "A configuration change has been made on a Redundant Switch. Host: %s."
/usr/OV/bin/addtrap -l rsCtiobli      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 108 -t 2 -S 0 -c "Status Events" -f - -F "Communications with the Redundant Switch has been established. Host: %s."
/usr/OV/bin/addtrap -l rsCtio         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 109 -t 4 -S 4 -c "Status Events" -f - -F "Communications with the Redundant Switch has been lost. Host: %s."
/usr/OV/bin/addtrap -l dcCtiobli      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 110 -t 2 -S 0 -c "Status Events" -f - -F "Communications with the DC power plant has been established. Host: %s."
/usr/OV/bin/addtrap -l dcCtio         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 111 -t 4 -S 4 -c "Status Events" -f - -F "Communications with the DC power plant has been lost. Host: %s."
/usr/OV/bin/addtrap -l dcPINChanged   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 112 -t 2 -S 0 -c "Status Events" -f - -F "The active PIN on the DC controller has been changed. Host: %s."
/usr/OV/bin/addtrap -l dcMajorAlarm   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 113 -t 4 -S 4 -c "Status Events" -f - -F "A Major alarm is active in the DC power plant. Host: %s."
/usr/OV/bin/addtrap -l dcMjorrmCred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 114 -t 2 -S 0 -c "Status Events" -f - -F "A Major alarm is no longer active in the DC power plant. Host: %s."
/usr/OV/bin/addtrap -l dcMinorAlarm   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 115 -t 3 -S 2 -c "Status Events" -f - -F "A Minor alarm is active in the DC power plant. Host: %s."
/usr/OV/bin/addtrap -l dcMrmCred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 116 -t 2 -S 0 -c "Status Events" -f - -F "A Minor alarm is no longer active in the DC power plant. Host: %s."
/usr/OV/bin/addtrap -l dcOyOn         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 117 -t 3 -S 2 -c "Status Events" -f - -F "An output relay has gone on in the DC power plant. Host: %s."
/usr/OV/bin/addtrap -l dcOyOf         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 118 -t 2 -S 0 -c "Status Events" -f - -F "An output relay has gone off in the DC power plant. Host: %s."
/usr/OV/bin/addtrap -l dcInputRelayOn -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 119 -t 3 -S 2 -c "Status Events" -f - -F "An input relay has gone on in the DC power plant. Host: %s."
/usr/OV/bin/addtrap -l dcIyOf         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 120 -t 2 -S 0 -c "Status Events" -f - -F "An input relay has gone off in the DC power plant. Host: %s."
/usr/OV/bin/addtrap -l logsed         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 121 -t 2 -S 0 -c "Status Events" -f - -F "The number of system power supplies has increased. Host: %s."
/usr/OV/bin/addtrap -l logsed         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 122 -t 2 -S 0 -c "Status Events" -f - -F "The number of system power supplies has decreased. Host: %s."
/usr/OV/bin/addtrap -l extlSwrCl      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 123 -t 2 -S 0 -c "Status Events" -f - -F "External Switch Gear %s closed. Host: %s."
/usr/OV/bin/addtrap -l extlSwrOp      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 124 -t 2 -S 0 -c "Status Events" -f - -F "External Switch Gear %s opened. Host: %s."
/usr/OV/bin/addtrap -l genlDe         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 125 -t 2 -S 0 -c "Status Events" -f - -F "%s APC Device event. Host: %s."
/usr/OV/bin/addtrap -l atsS           -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 126 -t 2 -S 0 -c "Status Events" -f - -F "The Automatic Transfer Switch has switched source. Host: %s."
/usr/OV/bin/addtrap -l atsLncy        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 127 -t 4 -S 4 -c "Status Events" -f - -F "The Automatic Transfer Switch has lost redundancy. Host: %s."
/usr/OV/bin/addtrap -l atsRncy        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 128 -t 2 -S 0 -c "Status Events" -f - -F "Redundancy has been restored to the Automatic Transfer Switch . Host: %s."
/usr/OV/bin/addtrap -l atsCnge        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 129 -t 2 -S 0 -c "Status Events" -f - -F "A configuration change has been made on a Automatic Transfer Switch. Host: %s."
/usr/OV/bin/addtrap -l atsCtiobli     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 130 -t 2 -S 0 -c "Status Events" -f - -F "Communications with the Automatic Transfer Switch has been established. Host: %s."
/usr/OV/bin/addtrap -l atsCtio        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 131 -t 4 -S 4 -c "Status Events" -f - -F "Communications with the Automatic Transfer Switch has been lost. Host: %s."
/usr/OV/bin/addtrap -l atsOverCurrent -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 132 -t 4 -S 4 -c "Status Events" -f - -F "Output Current has exceeded Threshold.  Host: %s."
/usr/OV/bin/addtrap -l atsOred        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 133 -t 2 -S 0 -c "Status Events" -f - -F "Output Current has returned below threshold. Host: %s."
/usr/OV/bin/addtrap -l atsPilu        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 134 -t 4 -S 4 -c "Status Events" -f - -F "The Automatic Transfer Switch Power Supply has failed. Host: %s."
/usr/OV/bin/addtrap -l atsPilured     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 135 -t 2 -S 0 -c "Status Events" -f - -F "The Automatic Transfer Switch Power Supply Failure Cleared. Host: %s."
/usr/OV/bin/addtrap -l dcMinsilArm    -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 136 -t 3 -S 2 -c "Status Events" -f - -F "A Mains Fail alarm is active in the DC power plant. Host: %s."
/usr/OV/bin/addtrap -l dcMinsilArmCre -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 137 -t 2 -S 0 -c "Status Events" -f - -F "Mains Fail alarm is no longer active in the DC power plant. Host: %s."
/usr/OV/bin/addtrap -l dcFanFailAlarm -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 138 -t 3 -S 2 -c "Status Events" -f - -F "A Fan Fail alarm is active in the DC power plant. Host: %s."
/usr/OV/bin/addtrap -l dcFnFailArmCre -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 139 -t 2 -S 0 -c "Status Events" -f - -F "A Fan Fail alarm is no longer active in the DC power plant. Host: %s."
/usr/OV/bin/addtrap -l dcRrm          -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 140 -t 3 -S 2 -c "Status Events" -f - -F "Rect. Overtemp alarm is active in the power plant. Host: %s."
/usr/OV/bin/addtrap -l dcRrmCred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 141 -t 2 -S 0 -c "Status Events" -f - -F "Rect. Overtemp alarm is no longer active in the power plant. Host: %s."
/usr/OV/bin/addtrap -l dcCrm          -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 142 -t 3 -S 2 -c "Status Events" -f - -F "A Current Limit alarm is active in the power plant. Host: %s."
/usr/OV/bin/addtrap -l dcCrmCred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 143 -t 2 -S 0 -c "Status Events" -f - -F "Current Limit alarm is no longer active in the power plant. Host: %s."
/usr/OV/bin/addtrap -l dcRilArm       -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 144 -t 3 -S 2 -c "Status Events" -f - -F "A Rect. Fail alarm is active in the power plant. Host: %s."
/usr/OV/bin/addtrap -l dcRilArmCred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 145 -t 2 -S 0 -c "Status Events" -f - -F "Rect. Fail alarm is no longer active in the power plant. Host: %s."
/usr/OV/bin/addtrap -l dcMilArm       -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 146 -t 3 -S 2 -c "Status Events" -f - -F "Multiple Rect. Fail alarm is active in the powerplant. Host: %s."
/usr/OV/bin/addtrap -l dcMilArmCred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 147 -t 2 -S 0 -c "Status Events" -f - -F "Multiple Rect Fail alarm is no longer active in the powerplant. Host: %s."
/usr/OV/bin/addtrap -l dcBttekerrm    -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 148 -t 3 -S 2 -c "Status Events" -f - -F "Batt. Breaker alarm is active in the power plant. Host: %s."
/usr/OV/bin/addtrap -l dcBttekerrmCre -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 149 -t 2 -S 0 -c "Status Events" -f - -F "Batt. Breaker alarm is no longer active in the power plant. Host: %s."
/usr/OV/bin/addtrap -l dcRrm          -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 150 -t 3 -S 2 -c "Status Events" -f - -F "A Rect. OVP alarm is active in the power plant. Host: %s."
/usr/OV/bin/addtrap -l dcRrmCred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 151 -t 2 -S 0 -c "Status Events" -f - -F "A Rect. OVP alarm is no longer active in the power plant. Host: %s."
/usr/OV/bin/addtrap -l dcLrm          -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 152 -t 3 -S 2 -c "Status Events" -f - -F "A LVD Imminent alarm is active in the powerplant. Host: %s."
/usr/OV/bin/addtrap -l dcLrmCred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 153 -t 2 -S 0 -c "Status Events" -f - -F "A LVD Imminent alarm is no longer active in the powerplant. Host: %s."
/usr/OV/bin/addtrap -l dcFuseCBAlarm  -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 154 -t 3 -S 2 -c "Status Events" -f - -F "A Fuse/CB alarm is active in the DC power plant. Host: %s."
/usr/OV/bin/addtrap -l dcFrmCred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 155 -t 2 -S 0 -c "Status Events" -f - -F "A Fuse/CB alarm is no longer active in the DC power plant. Host: %s."
/usr/OV/bin/addtrap -l dcBtteil       -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 156 -t 3 -S 2 -c "Status Events" -f - -F "A Battery Test failed in the DC power plant. Host: %s."
/usr/OV/bin/addtrap -l dcTturrm       -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 157 -t 3 -S 2 -c "Status Events" -f - -F "A Temperature alarm is active in the power plant. Host: %s."
/usr/OV/bin/addtrap -l dcTturrmCred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 158 -t 2 -S 0 -c "Status Events" -f - -F "A Temperature alarm is no longer active in the power plant. Host: %s."
/usr/OV/bin/addtrap -l dcHrm          -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 159 -t 3 -S 2 -c "Status Events" -f - -F "A Humidity alarm is active in the DC power plant. Host: %s."
/usr/OV/bin/addtrap -l dcHrmCred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 160 -t 2 -S 0 -c "Status Events" -f - -F "A Humidity alarm is no longer active in the DC power plant. Host: %s."
/usr/OV/bin/addtrap -l dcBtiobli      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 161 -t 2 -S 0 -c "Status Events" -f - -F "Power plant bridging board communications established. Host: %s."
/usr/OV/bin/addtrap -l dcBtio         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 162 -t 4 -S 4 -c "Status Events" -f - -F "Power plant bridging board communications lost. Host: %s."
/usr/OV/bin/addtrap -l iemtio         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 163 -t 4 -S 4 -c "Status Events" -f - -F "High temperature threshold of violation of %s %s on probe %s, %s. Host: %s."
/usr/OV/bin/addtrap -l iemtiored      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 164 -t 2 -S 0 -c "Status Events" -f - -F "High temperature threshold violation has been cleared on probe %s, %s. Host: %s."
/usr/OV/bin/addtrap -l iemtio         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 165 -t 4 -S 4 -c "Status Events" -f - -F "Low temperature threshold of violation of %s %s on probe %s, %s. Host: %s."
/usr/OV/bin/addtrap -l iemtiored      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 166 -t 2 -S 0 -c "Status Events" -f - -F "Low temperature threshold violation has been cleared on probe %s, %s. Host: %s."
/usr/OV/bin/addtrap -l iemtio         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 167 -t 4 -S 4 -c "Status Events" -f - -F "High humidity threshold of violation of %s percent relative humidity on probe %s, %s. Host: %s."
/usr/OV/bin/addtrap -l iemtiored      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 168 -t 2 -S 0 -c "Status Events" -f - -F "High humidity threshold violation on probe %s, %s, has been cleared. Host: %s."
/usr/OV/bin/addtrap -l iemtio         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 169 -t 4 -S 4 -c "Status Events" -f - -F "High humidity threshold of violation of %s percent relative humidity on probe %s, %s. Host: %s."
/usr/OV/bin/addtrap -l iemtiored      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 170 -t 2 -S 0 -c "Status Events" -f - -F "Low humidity threshold violation on probe %s, %s, has been cleared. Host: %s."
/usr/OV/bin/addtrap -l iem            -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 171 -t 3 -S 2 -c "Status Events" -f - -F "Probe has been disconnected. Host: %s."
/usr/OV/bin/addtrap -l iem            -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 172 -t 2 -S 0 -c "Status Events" -f - -F "Probe has been connected. Host: %s."
/usr/OV/bin/addtrap -l iemctFult      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 173 -t 4 -S 4 -c "Status Events" -f - -F "There is a fault on contact %s, %s. Host: %s."
/usr/OV/bin/addtrap -l iemctFultred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 174 -t 2 -S 0 -c "Status Events" -f - -F "There is a fault on contact %s, %s. Host: %s."
/usr/OV/bin/addtrap -l iemRelayFault  -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 175 -t 4 -S 4 -c "Status Events" -f - -F "Output relay %s, %s, has faulted because %s. Host: %s."
/usr/OV/bin/addtrap -l iemyFaultred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 176 -t 2 -S 0 -c "Status Events" -f - -F "Output relay %s, %s fault cleared. Host: %s."
/usr/OV/bin/addtrap -l bmBtManCob     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 177 -t 2 -S 0 -c "Status Events" -f - -F "Unit %i Communications Established. Host: %s."
/usr/OV/bin/addtrap -l bmBtManCo      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 178 -t 4 -S 4 -c "Status Events" -f - -F "Unit %i Communications Lost. Host: %s."
/usr/OV/bin/addtrap -l bmBtManKnrm    -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 179 -t 4 -S 4 -c "Status Events" -f - -F "Unit %i Knee Alarm Detected. Host: %s."
/usr/OV/bin/addtrap -l bmBtManKnrmCre -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 180 -t 2 -S 0 -c "Status Events" -f - -F "Unit %i Knee Alarm Cleared. Host: %s."
/usr/OV/bin/addtrap -l bmBtManChrgerm -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 181 -t 3 -S 2 -c "Status Events" -f - -F "Unit %i Charger Alarm Detected. Host: %s."
/usr/OV/bin/addtrap -l bmBtManChrgerm -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 182 -t 2 -S 0 -c "Status Events" -f - -F "Unit %i Charger Alarm Cleared. Host: %s."
/usr/OV/bin/addtrap -l bmBtManBatterm -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 183 -t 3 -S 2 -c "Status Events" -f - -F "Unit %i Battery Alarm Detected. Host: %s."
/usr/OV/bin/addtrap -l bmBtManBatterm -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 184 -t 2 -S 0 -c "Status Events" -f - -F "Unit %i Battery Alarm Cleared. Host: %s."
/usr/OV/bin/addtrap -l bmBtManEnrm    -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 185 -t 3 -S 2 -c "Status Events" -f - -F "Unit %i Environment Alarm Detected. Host: %s."
/usr/OV/bin/addtrap -l bmBtManEnrmCre -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 186 -t 2 -S 0 -c "Status Events" -f - -F "Unit %i Environment Alarm Cleared. Host: %s."
/usr/OV/bin/addtrap -l bmBtManMaintnc -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 187 -t 2 -S 0 -c "Status Events" -f - -F "Unit %i Maintenance Due Alarm Detected. Host: %s."
/usr/OV/bin/addtrap -l bmBtManMaintnc -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 188 -t 2 -S 0 -c "Status Events" -f - -F "Unit %i Maintenance Due Alarm Cleared. Host: %s."
/usr/OV/bin/addtrap -l pdutiobli      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 189 -t 2 -S 0 -c "Status Events" -f - -F "Communication Established. Host: %s."
/usr/OV/bin/addtrap -l pdutio         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 190 -t 4 -S 4 -c "Status Events" -f - -F "Communication Lost. Host: %s."
/usr/OV/bin/addtrap -l pduge          -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 191 -t 4 -S 4 -c "Status Events" -f - -F "Utility Line Undervoltage L%i. Host: %s."
/usr/OV/bin/addtrap -l pdugeCred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 192 -t 2 -S 0 -c "Status Events" -f - -F "Utility Line Undervoltage Cleared L%i. Host: %s."
/usr/OV/bin/addtrap -l pduge          -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 193 -t 4 -S 4 -c "Status Events" -f - -F "Utility Line Overvoltage L%i. Host: %s."
/usr/OV/bin/addtrap -l pdugeCred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 194 -t 2 -S 0 -c "Status Events" -f - -F "Utility Line Overvoltage Cleared L%i. Host: %s."
/usr/OV/bin/addtrap -l pdu            -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 195 -t 4 -S 4 -c "Status Events" -f - -F "Ground Overcurrent. Host: %s."
/usr/OV/bin/addtrap -l pdured         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 196 -t 2 -S 0 -c "Status Events" -f - -F "Ground Overcurrent Cleared. Host: %s."
/usr/OV/bin/addtrap -l pdunelge       -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 197 -t 4 -S 4 -c "Status Events" -f - -F "Circuit Panel Input Undervoltage L%i. Host: %s."
/usr/OV/bin/addtrap -l pdunelgeCred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 198 -t 2 -S 0 -c "Status Events" -f - -F "Circuit Panel Input Undervoltage Cleared L%i. Host: %s."
/usr/OV/bin/addtrap -l pdunelge       -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 199 -t 4 -S 4 -c "Status Events" -f - -F "Circuit Panel Input Overvoltage L%i. Host: %s."
/usr/OV/bin/addtrap -l pdunelgeCred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 200 -t 2 -S 0 -c "Status Events" -f - -F "Circuit Panel Input Overvoltage Cleared L%i. Host: %s."
/usr/OV/bin/addtrap -l pdunel         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 201 -t 4 -S 4 -c "Status Events" -f - -F "Circuit Panel Input Undercurrent L%i. Host: %s."
/usr/OV/bin/addtrap -l pdunelred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 202 -t 2 -S 0 -c "Status Events" -f - -F "Circuit Panel Input Undercurrent Cleared L%i. Host: %s."
/usr/OV/bin/addtrap -l pdunel         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 203 -t 4 -S 4 -c "Status Events" -f - -F "Circuit Panel Input Overcurrent L%i. Host: %s."
/usr/OV/bin/addtrap -l pdunelred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 204 -t 2 -S 0 -c "Status Events" -f - -F "Circuit Panel Input Overcurrent Cleared L%i. Host: %s."
/usr/OV/bin/addtrap -l pdunelnge      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 205 -t 4 -S 4 -c "Status Events" -f - -F "Circuit Panel Input Frequency Out Of Range. Host: %s."
/usr/OV/bin/addtrap -l pdunelngered   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 206 -t 2 -S 0 -c "Status Events" -f - -F "Circuit Panel Input Frequency No Longer Out Of Range. Host: %s."
/usr/OV/bin/addtrap -l pdunellOv      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 207 -t 4 -S 4 -c "Status Events" -f - -F "Circuit Panel Input Neutral Overcurrent. Host: %s."
/usr/OV/bin/addtrap -l pdunellOvred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 208 -t 2 -S 0 -c "Status Events" -f - -F "Circuit Panel Input Neutral Overcurrent Cleared. Host: %s."
/usr/OV/bin/addtrap -l pduSystemOff   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 209 -t 4 -S 4 -c "Status Events" -f - -F "PDU System Off. Host: %s."
/usr/OV/bin/addtrap -l pdutte         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 210 -t 4 -S 4 -c "Status Events" -f - -F "PDU is in On Battery Mode. Host: %s."
/usr/OV/bin/addtrap -l pduintncessM   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 211 -t 2 -S 0 -c "Status Events" -f - -F "PDU is in Maintenance Bypass Mode. Host: %s."
/usr/OV/bin/addtrap -l pdulByssM      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 212 -t 3 -S 2 -c "Status Events" -f - -F "PDU is in Atypical Bypass Mode. Host: %s."
/usr/OV/bin/addtrap -l pdunel         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 213 -t 4 -S 4 -c "Status Events" -f - -F "PDU is in No Panel Feed Mode. Host: %s."
/usr/OV/bin/addtrap -l pdutio         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 214 -t 2 -S 0 -c "Status Events" -f - -F "PDU is in Ups Operation Mode. Host: %s."
/usr/OV/bin/addtrap -l pdussM         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 215 -t 3 -S 2 -c "Status Events" -f - -F "PDU is in Forced Bypass Mode. Host: %s."
/usr/OV/bin/addtrap -l pdunsftur      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 216 -t 4 -S 4 -c "Status Events" -f - -F "Input Transformer Over Temperature. Host: %s."
/usr/OV/bin/addtrap -l pdunsfturred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 217 -t 2 -S 0 -c "Status Events" -f - -F "Input Transformer Over Temperature Cleared. Host: %s."
/usr/OV/bin/addtrap -l pdugeL         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 218 -t 4 -S 4 -c "Status Events" -f - -F "UPS Input Voltage L%i-N Lost. Host: %s."
/usr/OV/bin/addtrap -l pdugeR         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 219 -t 2 -S 0 -c "Status Events" -f - -F "UPS Input Voltage L%i-N Restored. Host: %s."
/usr/OV/bin/addtrap -l pductFult      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 220 -t 4 -S 4 -c "Status Events" -f - -F "Contact %i Abnormal. Host: %s."
/usr/OV/bin/addtrap -l pductFultred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 221 -t 2 -S 0 -c "Status Events" -f - -F "Contact %i Normal. Host: %s."
/usr/OV/bin/addtrap -l rPDnkPseLd     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 222 -t 3 -S 2 -c "Status Events" -f - -F "A bank or phase on the Rack PDU has violated the low load threshold. Host: %s."
/usr/OV/bin/addtrap -l rPDnkPseLdClre -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 223 -t 2 -S 0 -c "Status Events" -f - -F "The bank or phase low load condition on a Rack PDU has been cleared. Host: %s."
/usr/OV/bin/addtrap -l rPDnkPseNrOvd  -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 224 -t 3 -S 2 -c "Status Events" -f - -F "A bank or phase of the Rack PDU is near an overload condition. Host: %s."
/usr/OV/bin/addtrap -l rPDnkPseNrOvdC -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 225 -t 2 -S 0 -c "Status Events" -f - -F "Rack PDU bank or phase near overload condition has cleared. Host: %s."
/usr/OV/bin/addtrap -l rPDnkPseOd     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 226 -t 4 -S 4 -c "Status Events" -f - -F "A bank or phase of the Rack PDU is in an overload condition. Host: %s."
/usr/OV/bin/addtrap -l rPDnkPseOdClre -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 227 -t 2 -S 0 -c "Status Events" -f - -F "The bank or phase overload condition on a Rack PDU has cleared. Host: %s."
/usr/OV/bin/addtrap -l aruDnge        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 228 -t 2 -S 0 -c "Status Events" -f - -F "ARU device configuration change. Host: %s."
/usr/OV/bin/addtrap -l rmPtio         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 229 -t 4 -S 4 -c "Status Events" -f - -F "Communication Lost. Host: %s."
/usr/OV/bin/addtrap -l emstiobli      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 230 -t 2 -S 0 -c "Status Events" -f - -F "Communication Established. Host: %s."
/usr/OV/bin/addtrap -l emstio         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 231 -t 4 -S 4 -c "Status Events" -f - -F "Communication Lost. Host: %s."
/usr/OV/bin/addtrap -l ems            -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 232 -t 2 -S 0 -c "Status Events" -f - -F "Probe %s Connected. Host: %s."
/usr/OV/bin/addtrap -l ems            -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 233 -t 4 -S 4 -c "Status Events" -f - -F "Probe %s Disconnected. Host: %s."
/usr/OV/bin/addtrap -l ems            -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 234 -t 2 -S 0 -c "Status Events" -f - -F "Sensor %s Connected. Host: %s."
/usr/OV/bin/addtrap -l ems            -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 235 -t 4 -S 4 -c "Status Events" -f - -F "Sensor %s Disconnected. Host: %s."
/usr/OV/bin/addtrap -l emsSensorFault -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 236 -t 4 -S 4 -c "Status Events" -f - -F "Sensor %s Fault. Host: %s."
/usr/OV/bin/addtrap -l emsultred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 237 -t 2 -S 0 -c "Status Events" -f - -F "Sensor %s Fault Cleared. Host: %s."
/usr/OV/bin/addtrap -l emscon         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 238 -t 2 -S 0 -c "Status Events" -f - -F "Beacon Connected. Host: %s."
/usr/OV/bin/addtrap -l emscon         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 239 -t 4 -S 4 -c "Status Events" -f - -F "Beacon Disconnected. Host: %s."
/usr/OV/bin/addtrap -l emsBeaconOn    -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 240 -t 2 -S 0 -c "Status Events" -f - -F "Beacon On. Host: %s."
/usr/OV/bin/addtrap -l emsBeaconOff   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 241 -t 2 -S 0 -c "Status Events" -f - -F "Beacon Off. Host: %s."
/usr/OV/bin/addtrap -l emsMajorAlarm  -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 242 -t 4 -S 4 -c "Status Events" -f - -F "Major Alarm. Host: %s."
/usr/OV/bin/addtrap -l emsjorrmCred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 243 -t 2 -S 0 -c "Status Events" -f - -F "Major Alarm Cleared. Host: %s."
/usr/OV/bin/addtrap -l emsMinorAlarm  -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 244 -t 4 -S 4 -c "Status Events" -f - -F "Minor Alarm. Host: %s."
/usr/OV/bin/addtrap -l emsrmCred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 245 -t 2 -S 0 -c "Status Events" -f - -F "Minor Alarm Cleared. Host: %s."
/usr/OV/bin/addtrap -l emsteAl        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 246 -t 3 -S 2 -c "Status Events" -f - -F "Outlet %s to abnormal state %s. Host: %s."
/usr/OV/bin/addtrap -l emsteNl        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 247 -t 2 -S 0 -c "Status Events" -f - -F "Outlet %s to normal state %s. Host: %s."
/usr/OV/bin/addtrap -l emsctSteAl     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 248 -t 3 -S 2 -c "Status Events" -f - -F "Contact %s to abnormal state %s. Host: %s."
/usr/OV/bin/addtrap -l emsctSteNl     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 249 -t 2 -S 0 -c "Status Events" -f - -F "Contact %s to normal state %s. Host: %s."
/usr/OV/bin/addtrap -l emsyStteAl     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 250 -t 3 -S 2 -c "Status Events" -f - -F "Relay %s to abnormal state %s. Host: %s."
/usr/OV/bin/addtrap -l emsyStteNl     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 251 -t 2 -S 0 -c "Status Events" -f - -F "Relay %s to normal state %s. Host: %s."
/usr/OV/bin/addtrap -l emsnge         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 252 -t 2 -S 0 -c "Status Events" -f - -F "A device configuration change has been made on a EMS. Host: %s."
/usr/OV/bin/addtrap -l envtio         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 253 -t 4 -S 4 -c "Status Events" -f - -F "Overtemp (%s,%s) on Probe %s. Host: %s."
/usr/OV/bin/addtrap -l envtiored      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 254 -t 2 -S 0 -c "Status Events" -f - -F "Overtemp (%s,%s) on Probe %s cleared. Host: %s."
/usr/OV/bin/addtrap -l envtio         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 255 -t 4 -S 4 -c "Status Events" -f - -F "Undertemp (%s,%s) on Probe %s. Host: %s."
/usr/OV/bin/addtrap -l envtiored      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 256 -t 2 -S 0 -c "Status Events" -f - -F "Undertemp (%s,%s) on Probe %s cleared. Host: %s."
/usr/OV/bin/addtrap -l envtio         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 257 -t 4 -S 4 -c "Status Events" -f - -F "Over Humidity (%s) on Probe %s. Host: %s."
/usr/OV/bin/addtrap -l envtiored      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 258 -t 2 -S 0 -c "Status Events" -f - -F "Over Humidity (%s) on Probe %s cleared. Host: %s."
/usr/OV/bin/addtrap -l envtio         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 259 -t 4 -S 4 -c "Status Events" -f - -F "Under Humidity (%s) on Probe %s. Host: %s."
/usr/OV/bin/addtrap -l envtiored      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 260 -t 2 -S 0 -c "Status Events" -f - -F "Under Humidity (%s) on Probe %s cleared. Host: %s."
/usr/OV/bin/addtrap -l nlCtiobli      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 261 -t 2 -S 0 -c "Status Events" -f - -F "Communication Established. Host: %s."
/usr/OV/bin/addtrap -l rPDtiobli      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 266 -t 2 -S 0 -c "Status Events" -f - -F "Communication with Rack PDU [%s] established. Host: %s."
/usr/OV/bin/addtrap -l rPDtio         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 267 -t 4 -S 4 -c "Status Events" -f - -F "Communication with Rack PDU [%s] has been lost. Host: %s."
/usr/OV/bin/addtrap -l rPDUOutletOn   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 268 -t 2 -S 0 -c "Status Events" -f - -F "Outlet %s [%s] on Switched Rack PDU [%s] has turned on. Host: %s."
/usr/OV/bin/addtrap -l rPDUOutletOff  -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 269 -t 2 -S 0 -c "Status Events" -f - -F "Outlet %s [%s] on Switched Rack PDU [%s] has turned off. Host: %s."
/usr/OV/bin/addtrap -l rPDnge         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 270 -t 2 -S 0 -c "Status Events" -f - -F "Device configuration change made on Rack PDU [%s]. Host: %s."
/usr/OV/bin/addtrap -l rPDnge         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 271 -t 2 -S 0 -c "Status Events" -f - -F "Outlet %s [%s] configuration change made on Switched Rack PDU [%s]. Host: %s."
/usr/OV/bin/addtrap -l rPDULowLoad    -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 272 -t 3 -S 2 -c "Status Events" -f - -F "Rack PDU [%s], phase %s has violated the low load threshold. Host: %s."
/usr/OV/bin/addtrap -l rPDdClred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 273 -t 2 -S 0 -c "Status Events" -f - -F "Rack PDU [%s], phase %s low load condition cleared. Host: %s."
/usr/OV/bin/addtrap -l rPDrOvd        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 274 -t 3 -S 2 -c "Status Events" -f - -F "Rack PDU [%s], phase %s is near an overload condition. Host: %s."
/usr/OV/bin/addtrap -l rPDrOvdClred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 275 -t 2 -S 0 -c "Status Events" -f - -F "Rack PDU [%s], phase %s near overload condition has cleared. Host: %s."
/usr/OV/bin/addtrap -l rPDUOverload   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 276 -t 4 -S 4 -c "Status Events" -f - -F "Rack PDU [%s], phase %s is in an overload condition. Host: %s."
/usr/OV/bin/addtrap -l rPDdClred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 277 -t 2 -S 0 -c "Status Events" -f - -F "Rack PDU [%s], phase %s overload condition has cleared. Host: %s."
/usr/OV/bin/addtrap -l rPD1Faiil      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 278 -t 4 -S 4 -c "Status Events" -f - -F "Power Supply 1 on Rack PDU [%s] is in FAIL state. Host: %s."
/usr/OV/bin/addtrap -l rPD1Ok         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 279 -t 2 -S 0 -c "Status Events" -f - -F "Power Supply 1 on Rack PDU [%s] is operating normally. Host: %s."
/usr/OV/bin/addtrap -l rPD2Faiil      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 280 -t 4 -S 4 -c "Status Events" -f - -F "Power Supply 2 on Rack PDU [%s] is in FAIL state. Host: %s."
/usr/OV/bin/addtrap -l rPD2Ok         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 281 -t 2 -S 0 -c "Status Events" -f - -F "Power Supply 2 on Rack PDU [%s] is operating normally. Host: %s."
/usr/OV/bin/addtrap -l rPDseCnge      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 282 -t 2 -S 0 -c "Status Events" -f - -F "Phase %s configuration change made on Rack PDU [%s]. Host: %s."
/usr/OV/bin/addtrap -l rPDncend       -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 283 -t 2 -S 0 -c "Status Events" -f - -F "Cancel Pending Command made for outlet %s [%s], on Switched Rack PDU %s. Host: %s."
/usr/OV/bin/addtrap -l aruAtiobli     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 284 -t 2 -S 0 -c "Status Events" -f - -F "Communication Established. Host: %s."
/usr/OV/bin/addtrap -l aruAtio        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 285 -t 4 -S 4 -c "Status Events" -f - -F "Communication Lost. Host: %s."
/usr/OV/bin/addtrap -l aruFanFail     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 286 -t 4 -S 4 -c "Status Events" -f - -F "Fan Fail. Host: %s."
/usr/OV/bin/addtrap -l aruFnFailCred  -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 287 -t 2 -S 0 -c "Status Events" -f - -F "Fan Fail Cleared. Host: %s."
/usr/OV/bin/addtrap -l aruSmokeAlarm  -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 288 -t 4 -S 4 -c "Status Events" -f - -F "Smoke Alarm. Host: %s."
/usr/OV/bin/addtrap -l aruSrmCred     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 289 -t 2 -S 0 -c "Status Events" -f - -F "Smoke Alarm Cleared. Host: %s."
/usr/OV/bin/addtrap -l aruHturrm      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 290 -t 3 -S 2 -c "Status Events" -f - -F "High Temperature Alarm. Host: %s."
/usr/OV/bin/addtrap -l aruHturrmCred  -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 291 -t 2 -S 0 -c "Status Events" -f - -F "High Temperature Alarm Cleared. Host: %s."
/usr/OV/bin/addtrap -l aruEustturrm   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 292 -t 4 -S 4 -c "Status Events" -f - -F "Exhaust Temperature Alarm. Host: %s."
/usr/OV/bin/addtrap -l aruEustturrmCr -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 293 -t 2 -S 0 -c "Status Events" -f - -F "Exhaust Temperature Alarm Cleared. Host: %s."
/usr/OV/bin/addtrap -l envtiobli      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 294 -t 2 -S 0 -c "Status Events" -f - -F "Communication Established. Host: %s."
/usr/OV/bin/addtrap -l envtio         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 295 -t 4 -S 4 -c "Status Events" -f - -F "Communication Lost. Host: %s."
/usr/OV/bin/addtrap -l emsd           -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 296 -t 4 -S 4 -c "Status Events" -f - -F "Alink Power Overload. Host: %s."
/usr/OV/bin/addtrap -l emsdClred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 297 -t 2 -S 0 -c "Status Events" -f - -F "Alink Power Overload Cleared. Host: %s."
/usr/OV/bin/addtrap -l ups            -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 298 -t 2 -S 0 -c "Status Events" -f - -F "Outlet Group %i turned on Host: %s."
/usr/OV/bin/addtrap -l ups            -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 299 -t 3 -S 2 -c "Status Events" -f - -F "Outlet Group %i turned off. Host: %s."
/usr/OV/bin/addtrap -l smwlCo         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 300 -t 4 -S 4 -c "Status Events" -f - -F "A critical condition has been detected. Host: %s."
/usr/OV/bin/addtrap -l smwlCored      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 301 -t 2 -S 0 -c "Status Events" -f - -F "A critical condition has been cleared. Host: %s."
/usr/OV/bin/addtrap -l smwrni         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 302 -t 3 -S 2 -c "Status Events" -f - -F "A warning condition has been detected. Host: %s."
/usr/OV/bin/addtrap -l smwrnired      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 303 -t 2 -S 0 -c "Status Events" -f - -F "A warning condition has been cleared. Host: %s."
/usr/OV/bin/addtrap -l smwtiolCo      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 304 -t 2 -S 0 -c "Status Events" -f - -F "An informational condition has been detected. Host: %s."
/usr/OV/bin/addtrap -l smwtiolCored   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 305 -t 2 -S 0 -c "Status Events" -f - -F "An informational condition has been cleared. Host: %s."
/usr/OV/bin/addtrap -l airClCo        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 306 -t 4 -S 4 -c "Status Events" -f - -F "Critical condition: %s Host: %s."
/usr/OV/bin/addtrap -l airClCored     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 307 -t 2 -S 0 -c "Status Events" -f - -F "Critical condition cleared: %s Host: %s."
/usr/OV/bin/addtrap -l airWrni        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 308 -t 3 -S 2 -c "Status Events" -f - -F "Warning condition set: %s Host: %s."
/usr/OV/bin/addtrap -l airWrnired     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 309 -t 2 -S 0 -c "Status Events" -f - -F "Warning condition cleared: %s Host: %s."
/usr/OV/bin/addtrap -l airItiolCo     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 310 -t 2 -S 0 -c "Status Events" -f - -F "Informational condition set: %s Host: %s."
/usr/OV/bin/addtrap -l airItiolCored  -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 311 -t 2 -S 0 -c "Status Events" -f - -F "Informational condition cleared: %s Host: %s."
/usr/OV/bin/addtrap -l xPDgeLrm       -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 312 -t 4 -S 4 -c "Status Events" -f - -F "Input voltage %s is below threshold%s. Host: %s."
/usr/OV/bin/addtrap -l xPDgeLrmCred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 313 -t 2 -S 0 -c "Status Events" -f - -F "Main input voltage %s alarm cleared. Host: %s."
/usr/OV/bin/addtrap -l xPDgeHrm       -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 314 -t 4 -S 4 -c "Status Events" -f - -F "Input voltage %s is above threshold %s. Host: %s."
/usr/OV/bin/addtrap -l xPDgeHrmCred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 315 -t 2 -S 0 -c "Status Events" -f - -F "Main input high voltage %s alarm cleared. Host: %s."
/usr/OV/bin/addtrap -l xPDssVgeLrm    -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 316 -t 4 -S 4 -c "Status Events" -f - -F "Bypass input voltage %s is below threshold %s. Host: %s."
/usr/OV/bin/addtrap -l xPDssVgeLrmCre -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 317 -t 2 -S 0 -c "Status Events" -f - -F "Bypass input low voltage %s alarm cleared. Host: %s."
/usr/OV/bin/addtrap -l xPDssVgeHrm    -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 318 -t 4 -S 4 -c "Status Events" -f - -F "Bypass input voltage %s is above threshold %s. Host: %s."
/usr/OV/bin/addtrap -l xPDssVgeHrmCre -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 319 -t 2 -S 0 -c "Status Events" -f - -F "Bypass input high voltage %s alarm cleared. Host: %s."
/usr/OV/bin/addtrap -l xPDgeLrm       -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 320 -t 4 -S 4 -c "Status Events" -f - -F "Output voltage %s is above threshold %s. Host: %s."
/usr/OV/bin/addtrap -l xPDgeLrmCred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 321 -t 2 -S 0 -c "Status Events" -f - -F "Output low voltage %s alarm cleared. Host: %s."
/usr/OV/bin/addtrap -l xPDgeHrm       -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 322 -t 4 -S 4 -c "Status Events" -f - -F "Output voltage %s is above threshold %s. Host: %s."
/usr/OV/bin/addtrap -l xPDgeHrmCred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 323 -t 2 -S 0 -c "Status Events" -f - -F "Output high voltage %s alarm cleared. Host: %s."
/usr/OV/bin/addtrap -l xPDrm          -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 324 -t 4 -S 4 -c "Status Events" -f - -F "Output current %s is below threshold %s. Host: %s."
/usr/OV/bin/addtrap -l xPDrmCred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 325 -t 2 -S 0 -c "Status Events" -f - -F "Output low current %s alarm cleared. Host: %s."
/usr/OV/bin/addtrap -l xPDrm          -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 326 -t 4 -S 4 -c "Status Events" -f - -F "Output current %s is above threshold %s. Host: %s."
/usr/OV/bin/addtrap -l xPDrmCred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 327 -t 2 -S 0 -c "Status Events" -f - -F "Output high current %s alarm cleared. Host: %s."
/usr/OV/bin/addtrap -l xPDrm          -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 328 -t 4 -S 4 -c "Status Events" -f - -F "Output frequency alarm. Host: %s."
/usr/OV/bin/addtrap -l xPDrmCred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 329 -t 2 -S 0 -c "Status Events" -f - -F "Output frequency in range. Host: %s."
/usr/OV/bin/addtrap -l xPDrm          -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 330 -t 4 -S 4 -c "Status Events" -f - -F "Earth ground current %i is above threshold %s. Host: %s."
/usr/OV/bin/addtrap -l xPDrmCred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 331 -t 2 -S 0 -c "Status Events" -f - -F "Earth ground high current %s alarm cleared. Host: %s."
/usr/OV/bin/addtrap -l xPDctSteAl     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 332 -t 4 -S 4 -c "Status Events" -f - -F "Input contact %s to abnormal state %s. Host: %s."
/usr/OV/bin/addtrap -l xPDctSteNl     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 333 -t 2 -S 0 -c "Status Events" -f - -F "Input contact %s to normal state %s. Host: %s."
/usr/OV/bin/addtrap -l xPDlCurm       -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 334 -t 3 -S 2 -c "Status Events" -f - -F "Output neutral current %s is above threshold %s. Host: %s."
/usr/OV/bin/addtrap -l xPDlCurmCred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 335 -t 2 -S 0 -c "Status Events" -f - -F "Output neutral high current %s alarm cleared. Host: %s."
/usr/OV/bin/addtrap -l xPDnAlrm       -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 336 -t 4 -S 4 -c "Status Events" -f - -F "Cooling fan failure. Host: %s."
/usr/OV/bin/addtrap -l xPDnAlrmCred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 337 -t 2 -S 0 -c "Status Events" -f - -F "Cooling fan alarm cleared. Host: %s."
/usr/OV/bin/addtrap -l xPDnsfrm       -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 338 -t 4 -S 4 -c "Status Events" -f - -F "Transformer temp alarm. Host: %s."
/usr/OV/bin/addtrap -l xPDnsfrmCred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 339 -t 2 -S 0 -c "Status Events" -f - -F "Transformer temp alarm cleared. Host: %s."
/usr/OV/bin/addtrap -l xPDnchrm       -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 340 -t 3 -S 2 -c "Status Events" -f - -F "Branch circuit current %s is below threshold %s. Host: %s."
/usr/OV/bin/addtrap -l xPDnchrmCred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 341 -t 2 -S 0 -c "Status Events" -f - -F "Branch circuit low current %s alarm cleared. Host: %s."
/usr/OV/bin/addtrap -l xPDnchrm       -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 342 -t 3 -S 2 -c "Status Events" -f - -F "Branch circuit current %s is above threshold %s. Host: %s."
/usr/OV/bin/addtrap -l xPDnchrmCred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 343 -t 2 -S 0 -c "Status Events" -f - -F "Branch circuit high current %s alarm cleared. Host: %s."
/usr/OV/bin/addtrap -l xPDlCo         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 344 -t 4 -S 4 -c "Status Events" -f - -F "Internal communication error. Host: %s."
/usr/OV/bin/addtrap -l emsrdwreSteAl  -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 345 -t 4 -S 4 -c "Status Events" -f - -F "Hardware is in an abnormal state. Host: %s."
/usr/OV/bin/addtrap -l emsrdwreSteNl  -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 346 -t 2 -S 0 -c "Status Events" -f - -F "Hardware is in its normal state. Host: %s."
/usr/OV/bin/addtrap -l ceS            -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 347 -t 4 -S 4 -c "Status Events" -f - -F "Severe condition set: %s Host: %s."
/usr/OV/bin/addtrap -l ceSred         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 348 -t 2 -S 0 -c "Status Events" -f - -F "Severe condition cleared: %s Host: %s."
/usr/OV/bin/addtrap -l ceWrni         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 349 -t 3 -S 2 -c "Status Events" -f - -F "Warning condition set: %s Host: %s."
/usr/OV/bin/addtrap -l ceWrnired      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 350 -t 2 -S 0 -c "Status Events" -f - -F "Warning condition cleared: %s Host: %s."
/usr/OV/bin/addtrap -l ceItiolCo      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 351 -t 2 -S 0 -c "Status Events" -f - -F "Informational condition set: %s Host: %s."
/usr/OV/bin/addtrap -l ceItiolCored   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 352 -t 2 -S 0 -c "Status Events" -f - -F "Informational condition cleared: %s Host: %s."
/usr/OV/bin/addtrap -l upslOvtur      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 353 -t 3 -S 2 -c "Status Events" -f - -F "The internal over temperature condition exists. Host: %s."
/usr/OV/bin/addtrap -l upslOvturred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 354 -t 2 -S 0 -c "Status Events" -f - -F "The internal over temperature condition cleared. Host: %s."
/usr/OV/bin/addtrap -l upsMpuReset    -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 355 -t 2 -S 0 -c "Status Events" -f - -F "The MPU has been reset. Host: %s."
/usr/OV/bin/addtrap -l ups            -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 356 -t 2 -S 0 -c "Status Events" -f - -F "The Output Switch is closed. Host: %s."
/usr/OV/bin/addtrap -l ups            -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 357 -t 2 -S 0 -c "Status Events" -f - -F "The Output Switch is open. Host: %s."
/usr/OV/bin/addtrap -l upslibtiockCng -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 358 -t 2 -S 0 -c "Status Events" -f - -F "A calibration value in the stack was changed. Host: %s."
/usr/OV/bin/addtrap -l envxTetio      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 359 -t 4 -S 4 -c "Status Events" -f - -F "Over max temp (%s,%s) on Probe %s. Host: %s."
/usr/OV/bin/addtrap -l envxTetiored   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 360 -t 2 -S 0 -c "Status Events" -f - -F "Over max temp (%s,%s) on Probe %s cleared. Host: %s."
/usr/OV/bin/addtrap -l envtio         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 361 -t 4 -S 4 -c "Status Events" -f - -F "Under min temp (%s,%s) on Probe %s. Host: %s."
/usr/OV/bin/addtrap -l envtiored      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 362 -t 2 -S 0 -c "Status Events" -f - -F "Under min temp (%s,%s) on Probe %s cleared. Host: %s."
/usr/OV/bin/addtrap -l envxHutio      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 363 -t 4 -S 4 -c "Status Events" -f - -F "Over max Humidity (%s) on Probe %s. Host: %s."
/usr/OV/bin/addtrap -l envxHutiored   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 364 -t 2 -S 0 -c "Status Events" -f - -F "Over max Humidity (%s) on Probe %s cleared. Host: %s."
/usr/OV/bin/addtrap -l envtio         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 365 -t 4 -S 4 -c "Status Events" -f - -F "Under min Humidity (%s) on Probe %s. Host: %s."
/usr/OV/bin/addtrap -l envtiored      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 366 -t 2 -S 0 -c "Status Events" -f - -F "Under min Humidity (%s) on Probe %s cleared. Host: %s."
/usr/OV/bin/addtrap -l envteVtio      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 367 -t 4 -S 4 -c "Status Events" -f - -F "Short-term inc. temp rate violation. (%s,%s) on Probe %s. Host: %s."
/usr/OV/bin/addtrap -l envteVtiored   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 368 -t 2 -S 0 -c "Status Events" -f - -F "Short-term inc. temp rate violation (%s,%s) on Probe %s cleared. Host: %s."
/usr/OV/bin/addtrap -l envteVtio      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 369 -t 4 -S 4 -c "Status Events" -f - -F "Short-term dec. temp rate violation. (%s,%s) on Probe %s. Host: %s."
/usr/OV/bin/addtrap -l envteVtiored   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 370 -t 2 -S 0 -c "Status Events" -f - -F "Short-term dec. temp rate violation (%s,%s) on Probe %s cleared. Host: %s."
/usr/OV/bin/addtrap -l envteVtio      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 371 -t 4 -S 4 -c "Status Events" -f - -F "Long-term inc. temp rate violation. (%s,%s) on Probe %s. Host: %s."
/usr/OV/bin/addtrap -l envteVtiored   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 372 -t 2 -S 0 -c "Status Events" -f - -F "Long-term inc. temp rate violation (%s,%s) on Probe %s cleared. Host: %s."
/usr/OV/bin/addtrap -l envteVtio      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 373 -t 4 -S 4 -c "Status Events" -f - -F "Long-term dec. temp rate violation. (%s,%s) on Probe %s. Host: %s."
/usr/OV/bin/addtrap -l envteVtiored   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 374 -t 2 -S 0 -c "Status Events" -f - -F "Long-term dec. temp rate violation (%s,%s) on Probe %s cleared. Host: %s."
/usr/OV/bin/addtrap -l bmslCo         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 375 -t 4 -S 4 -c "Status Events" -f - -F "Critical condition: %s Host: %s."
/usr/OV/bin/addtrap -l bmslCored      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 376 -t 2 -S 0 -c "Status Events" -f - -F "Critical condition cleared: %s Host: %s."
/usr/OV/bin/addtrap -l bmsrni         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 377 -t 3 -S 2 -c "Status Events" -f - -F "Warning condition set: %s Host: %s."
/usr/OV/bin/addtrap -l bmsrnired      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 378 -t 2 -S 0 -c "Status Events" -f - -F "Warning condition cleared: %s Host: %s."
/usr/OV/bin/addtrap -l bmstiolCo      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 379 -t 2 -S 0 -c "Status Events" -f - -F "Informational condition set: %s Host: %s."
/usr/OV/bin/addtrap -l bmstiolCored   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 380 -t 2 -S 0 -c "Status Events" -f - -F "Informational condition cleared: %s Host: %s."
/usr/OV/bin/addtrap -l xATgeLrm       -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 381 -t 4 -S 4 -c "Status Events" -f - -F "Output voltage %s is below threshold %s. Host: %s."
/usr/OV/bin/addtrap -l xATgeLrmCred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 382 -t 2 -S 0 -c "Status Events" -f - -F "Output low voltage %s alarm cleared. Host: %s."
/usr/OV/bin/addtrap -l xATgeHrm       -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 383 -t 4 -S 4 -c "Status Events" -f - -F "Output voltage %s is above threshold %s. Host: %s."
/usr/OV/bin/addtrap -l xATgeHrmCred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 384 -t 2 -S 0 -c "Status Events" -f - -F "Output high voltage %s alarm cleared. Host: %s."
/usr/OV/bin/addtrap -l xATrm          -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 385 -t 4 -S 4 -c "Status Events" -f - -F "Output current %s is below threshold %s. Host: %s."
/usr/OV/bin/addtrap -l xATrmCred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 386 -t 2 -S 0 -c "Status Events" -f - -F "Output low current %s alarm cleared. Host: %s."
/usr/OV/bin/addtrap -l xATrm          -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 387 -t 4 -S 4 -c "Status Events" -f - -F "Output current %s is above threshold %s. Host: %s."
/usr/OV/bin/addtrap -l xATrmCred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 388 -t 2 -S 0 -c "Status Events" -f - -F "Output high current %s alarm cleared. Host: %s."
/usr/OV/bin/addtrap -l xATrm          -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 389 -t 4 -S 4 -c "Status Events" -f - -F "Output frequency is out-of-range. Host: %s."
/usr/OV/bin/addtrap -l xATrmCred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 390 -t 2 -S 0 -c "Status Events" -f - -F "Output frequency in range. Host: %s."
/usr/OV/bin/addtrap -l xATlCo         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 391 -t 4 -S 4 -c "Status Events" -f - -F "Internal communication error. Host: %s."
/usr/OV/bin/addtrap -l xATlCored      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 392 -t 2 -S 0 -c "Status Events" -f - -F "ATS Communication error cleared. Host: %s."
/usr/OV/bin/addtrap -l xATtaCComtch   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 393 -t 4 -S 4 -c "Status Events" -f - -F "ATS data mismatch error. Host: %s."
/usr/OV/bin/addtrap -l xATtaCComtchre -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 394 -t 2 -S 0 -c "Status Events" -f - -F "ATS data mismatch error cleared. Host: %s."
/usr/OV/bin/addtrap -l xAT            -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 395 -t 3 -S 2 -c "Status Events" -f - -F "ATS/Generator communication lost. Host: %s."
/usr/OV/bin/addtrap -l xATbli         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 396 -t 2 -S 0 -c "Status Events" -f - -F "ATS/generator communication established. Host: %s."
/usr/OV/bin/addtrap -l xATlPo         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 397 -t 3 -S 2 -c "Status Events" -f - -F "Transferred to neutral. Host: %s."
/usr/OV/bin/addtrap -l xATnsf         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 398 -t 2 -S 0 -c "Status Events" -f - -F "Source-to-Source transfer. Host: %s."
/usr/OV/bin/addtrap -l xATlATult      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 399 -t 4 -S 4 -c "Status Events" -f - -F "ATS internal fault detected. Host: %s."
/usr/OV/bin/addtrap -l xATlATultred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 400 -t 2 -S 0 -c "Status Events" -f - -F "ATS internal fault cleared. Host: %s."
/usr/OV/bin/addtrap -l xATrtA         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 401 -t 2 -S 0 -c "Status Events" -f - -F "Engine Start asserted. Host: %s."
/usr/OV/bin/addtrap -l xAT            -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 402 -t 2 -S 0 -c "Status Events" -f - -F "Engine Stop asserted. Host: %s."
/usr/OV/bin/addtrap -l xATrtFilu      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 403 -t 4 -S 4 -c "Status Events" -f - -F "Generator failed to start. Host: %s."
/usr/OV/bin/addtrap -l xATilu         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 404 -t 3 -S 2 -c "Status Events" -f - -F "Generator failed to stop. Host: %s."
/usr/OV/bin/addtrap -l xATtic         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 405 -t 4 -S 4 -c "Status Events" -f - -F "ATS not in auto. Host: %s."
/usr/OV/bin/addtrap -l xATticred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 406 -t 2 -S 0 -c "Status Events" -f - -F "ATS in auto mode. Host: %s."
/usr/OV/bin/addtrap -l xATSEpoTripped -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 407 -t 4 -S 4 -c "Status Events" -f - -F "EPO tripped. Host: %s."
/usr/OV/bin/addtrap -l xATSEpoReset   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 408 -t 2 -S 0 -c "Status Events" -f - -F "EPO armed. Host: %s."
/usr/OV/bin/addtrap -l xAT            -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 409 -t 3 -S 2 -c "Status Events" -f - -F "EPO disabled. Host: %s."
/usr/OV/bin/addtrap -l xATSEpoArmed   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 410 -t 2 -S 0 -c "Status Events" -f - -F "EPO armed. Host: %s."
/usr/OV/bin/addtrap -l xATted         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 411 -t 2 -S 0 -c "Status Events" -f - -F "Test initiated. Host: %s."
/usr/OV/bin/addtrap -l xATnce         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 412 -t 2 -S 0 -c "Status Events" -f - -F "Test canceled. Host: %s."
/usr/OV/bin/addtrap -l xATSTestFailed -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 413 -t 4 -S 4 -c "Status Events" -f - -F "Initiated test failed. Host: %s."
/usr/OV/bin/addtrap -l xATSTestPassed -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 414 -t 2 -S 0 -c "Status Events" -f - -F "Initiated test passed. Host: %s."
/usr/OV/bin/addtrap -l xATctSteAl     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 415 -t 4 -S 4 -c "Status Events" -f - -F "Input contact %s has changed to its abnormal state %s. Host: %s."
/usr/OV/bin/addtrap -l xATctSteNl     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 416 -t 2 -S 0 -c "Status Events" -f - -F "Input contact %s has changed to its normal state %s. Host: %s."
/usr/OV/bin/addtrap -l xATrtCctMtch   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 417 -t 4 -S 4 -c "Status Events" -f - -F "Generator/ATS start contact mismatch. Host: %s."
/usr/OV/bin/addtrap -l xATrtCctMtchre -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 418 -t 2 -S 0 -c "Status Events" -f - -F "Generator/ATS start contact mismatch cleared. Host: %s."
/usr/OV/bin/addtrap -l xATrm          -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 419 -t 3 -S 2 -c "Status Events" -f - -F "Panel door open alarm. Host: %s."
/usr/OV/bin/addtrap -l xATrmCred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 420 -t 2 -S 0 -c "Status Events" -f - -F "Panel door open alarm cleared. Host: %s."
/usr/OV/bin/addtrap -l xATckurm       -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 421 -t 3 -S 2 -c "Status Events" -f - -F "ATS DC backup failure. Host: %s."
/usr/OV/bin/addtrap -l xATckurmCred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 422 -t 2 -S 0 -c "Status Events" -f - -F "DC backup alarm cleared. Host: %s."
/usr/OV/bin/addtrap -l xATtorntLrm    -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 423 -t 4 -S 4 -c "Status Events" -f - -F "Generator low coolant level alarm. Host: %s."
/usr/OV/bin/addtrap -l xATtorntLrmCre -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 424 -t 2 -S 0 -c "Status Events" -f - -F "Generator low coolant level alarm cleared. Host: %s."
/usr/OV/bin/addtrap -l xATtorntLrm    -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 425 -t 4 -S 4 -c "Status Events" -f - -F "Generator very low coolant level alarm. Host: %s."
/usr/OV/bin/addtrap -l xATtorntLrmCre -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 426 -t 2 -S 0 -c "Status Events" -f - -F "Generator very low coolant level alarm cleared. Host: %s."
/usr/OV/bin/addtrap -l xATtorntTrm    -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 427 -t 4 -S 4 -c "Status Events" -f - -F "Generator high coolant temperature alarm. Host: %s."
/usr/OV/bin/addtrap -l xATtorntTrmCre -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 428 -t 2 -S 0 -c "Status Events" -f - -F "Generator high coolant temperature alarm cleared. Host: %s."
/usr/OV/bin/addtrap -l xATtorntTrm    -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 429 -t 4 -S 4 -c "Status Events" -f - -F "Generator very high coolant temperature alarm. Host: %s."
/usr/OV/bin/addtrap -l xATtorntTrmCre -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 430 -t 2 -S 0 -c "Status Events" -f - -F "Generator very high coolant temperature alarm cleared. Host: %s."
/usr/OV/bin/addtrap -l xATtorntTrm    -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 431 -t 3 -S 2 -c "Status Events" -f - -F "Generator low coolant temperature alarm. Host: %s."
/usr/OV/bin/addtrap -l xATtorntTrmCre -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 432 -t 2 -S 0 -c "Status Events" -f - -F "Generator low coolant temperature alarm cleared. Host: %s."
/usr/OV/bin/addtrap -l xATtorrm       -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 433 -t 4 -S 4 -c "Status Events" -f - -F "Generator low oil level alarm. Host: %s."
/usr/OV/bin/addtrap -l xATtorrmCred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 434 -t 2 -S 0 -c "Status Events" -f - -F "Generator low oil level alarm cleared. Host: %s."
/usr/OV/bin/addtrap -l xATtorttenkArm -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 435 -t 4 -S 4 -c "Status Events" -f - -F "Generator low battery volts while cranking alarm. Host: %s."
/usr/OV/bin/addtrap -l xATtorttenkArm -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 436 -t 2 -S 0 -c "Status Events" -f - -F "Generator low battery volts while cranking alarm cleared. Host: %s."
/usr/OV/bin/addtrap -l xATtorttenkArm -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 437 -t 4 -S 4 -c "Status Events" -f - -F "Generator v.low battery volts while cranking alarm. Host: %s."
/usr/OV/bin/addtrap -l xATtorttenkArm -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 438 -t 2 -S 0 -c "Status Events" -f - -F "Generator v.low battery volts while cranking alarm cleared. Host: %s."
/usr/OV/bin/addtrap -l xATtor         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 439 -t 4 -S 4 -c "Status Events" -f - -F "Generator emergency stop engaged. Host: %s."
/usr/OV/bin/addtrap -l xATtorred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 440 -t 2 -S 0 -c "Status Events" -f - -F "Generator emergency stop condition cleared. Host: %s."
/usr/OV/bin/addtrap -l xATtortte      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 441 -t 3 -S 2 -c "Status Events" -f - -F "Generator high battery volts. Host: %s."
/usr/OV/bin/addtrap -l xATtorttered   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 442 -t 2 -S 0 -c "Status Events" -f - -F "Generator high battery volts condition cleared. Host: %s."
/usr/OV/bin/addtrap -l xATtortte      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 443 -t 4 -S 4 -c "Status Events" -f - -F "Generator low battery volts. Host: %s."
/usr/OV/bin/addtrap -l xATtorttered   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 444 -t 2 -S 0 -c "Status Events" -f - -F "Generator low battery volts condition cleared. Host: %s."
/usr/OV/bin/addtrap -l xATtor         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 445 -t 4 -S 4 -c "Status Events" -f - -F "Generator not-in-auto. Host: %s."
/usr/OV/bin/addtrap -l xATtorred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 446 -t 2 -S 0 -c "Status Events" -f - -F "Generator not-in-auto cleared. Host: %s."
/usr/OV/bin/addtrap -l xATtor         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 447 -t 4 -S 4 -c "Status Events" -f - -F "Generator low oil pressure. Host: %s."
/usr/OV/bin/addtrap -l xATtorred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 448 -t 2 -S 0 -c "Status Events" -f - -F "Generator low oil pressure condition cleared. Host: %s."
/usr/OV/bin/addtrap -l xATtor         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 449 -t 4 -S 4 -c "Status Events" -f - -F "Generator v.low oil pressure. Host: %s."
/usr/OV/bin/addtrap -l xATtorred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 450 -t 2 -S 0 -c "Status Events" -f - -F "Generator v.low oil pressure condition cleared. Host: %s."
/usr/OV/bin/addtrap -l xATtord        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 451 -t 4 -S 4 -c "Status Events" -f - -F "Generator on overload event. Host: %s."
/usr/OV/bin/addtrap -l xATtordClred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 452 -t 2 -S 0 -c "Status Events" -f - -F "Generator on overload event cleared. Host: %s."
/usr/OV/bin/addtrap -l xATtor         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 453 -t 4 -S 4 -c "Status Events" -f - -F "State of the Generator AC voltage. Host: %s."
/usr/OV/bin/addtrap -l xATtorred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 454 -t 2 -S 0 -c "Status Events" -f - -F "State of the Generator AC voltage cleared. Host: %s."
/usr/OV/bin/addtrap -l xATtor         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 455 -t 4 -S 4 -c "Status Events" -f - -F "State of the Generator AC voltage. Host: %s."
/usr/OV/bin/addtrap -l xATtorred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 456 -t 2 -S 0 -c "Status Events" -f - -F "State of the Generator AC voltage cleared. Host: %s."
/usr/OV/bin/addtrap -l xATtor         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 457 -t 4 -S 4 -c "Status Events" -f - -F "Generator overspeed condition. Host: %s."
/usr/OV/bin/addtrap -l xATtorred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 458 -t 2 -S 0 -c "Status Events" -f - -F "Generator overspeed condition cleared. Host: %s."
/usr/OV/bin/addtrap -l xATtor         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 459 -t 4 -S 4 -c "Status Events" -f - -F "Generator engine is cold. Host: %s."
/usr/OV/bin/addtrap -l xATtorred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 460 -t 2 -S 0 -c "Status Events" -f - -F "Engine is cold to start condition cleared. Host: %s."
/usr/OV/bin/addtrap -l xATtorker      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 461 -t 4 -S 4 -c "Status Events" -f - -F "Generator output breaker open. Host: %s."
/usr/OV/bin/addtrap -l xATtorkerred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 462 -t 2 -S 0 -c "Status Events" -f - -F "Generator output breaker open cleared. Host: %s."
/usr/OV/bin/addtrap -l xATtorrm       -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 463 -t 3 -S 2 -c "Status Events" -f - -F "Generator low fuel level alarm. Host: %s."
/usr/OV/bin/addtrap -l xATtorrmCred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 464 -t 2 -S 0 -c "Status Events" -f - -F "Generator low fuel level alarm cleared. Host: %s."
/usr/OV/bin/addtrap -l xATtorrm       -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 465 -t 4 -S 4 -c "Status Events" -f - -F "Generator very low fuel level alarm. Host: %s."
/usr/OV/bin/addtrap -l xATtorrmCred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 466 -t 2 -S 0 -c "Status Events" -f - -F "Generator very low fuel level alarm cleared. Host: %s."
/usr/OV/bin/addtrap -l xATtorrm       -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 467 -t 3 -S 2 -c "Status Events" -f - -F "Generator low run time alarm. Host: %s."
/usr/OV/bin/addtrap -l xATtorrmCred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 468 -t 2 -S 0 -c "Status Events" -f - -F "Generator low run time alarm. Host: %s."
/usr/OV/bin/addtrap -l xATtorrm       -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 469 -t 4 -S 4 -c "Status Events" -f - -F "Generator very low run time alarm. Host: %s."
/usr/OV/bin/addtrap -l xATtorrmCred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 470 -t 2 -S 0 -c "Status Events" -f - -F "Generator very low run time alarm. Host: %s."
/usr/OV/bin/addtrap -l xATtorrm       -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 471 -t 3 -S 2 -c "Status Events" -f - -F "Generator maintenance due. Host: %s."
/usr/OV/bin/addtrap -l xATtorrmCred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 472 -t 2 -S 0 -c "Status Events" -f - -F "Generator service alarm is cleared. Host: %s."
/usr/OV/bin/addtrap -l xATtor         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 473 -t 4 -S 4 -c "Status Events" -f - -F "Generator shutdown Host: %s."
/usr/OV/bin/addtrap -l xATtorred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 474 -t 2 -S 0 -c "Status Events" -f - -F "Generator shutdown is cleared. Host: %s."
/usr/OV/bin/addtrap -l xATtortterge   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 475 -t 4 -S 4 -c "Status Events" -f - -F "Generator battery charger is nonfunctional Host: %s."
/usr/OV/bin/addtrap -l xATtorttergere -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 476 -t 2 -S 0 -c "Status Events" -f - -F "Fault in the generator battery charger is cleared. Host: %s."
/usr/OV/bin/addtrap -l xATtor         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 477 -t 3 -S 2 -c "Status Events" -f - -F "Generator generic event. Host: %s."
/usr/OV/bin/addtrap -l xATtorred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 478 -t 2 -S 0 -c "Status Events" -f - -F "Generic generator event is cleared. Host: %s."
/usr/OV/bin/addtrap -l xPDlCored      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 479 -t 2 -S 0 -c "Status Events" -f - -F "PDU Communication error cleared. Host: %s."
/usr/OV/bin/addtrap -l xPDteArm       -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 480 -t 4 -S 4 -c "Status Events" -f - -F "PDU state change alarm %s. Host: %s."
/usr/OV/bin/addtrap -l xPDteArmCred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 481 -t 2 -S 0 -c "Status Events" -f - -F "PDU normal state change %s. Host: %s."
/usr/OV/bin/addtrap -l xPD            -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 482 -t 3 -S 2 -c "Status Events" -f - -F "EPO disabled. Host: %s."
/usr/OV/bin/addtrap -l xPDUEpoArmed   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 483 -t 2 -S 0 -c "Status Events" -f - -F "EPO armed. Host: %s."
/usr/OV/bin/addtrap -l xPDrm          -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 484 -t 4 -S 4 -c "Status Events" -f - -F "Fuse %s detected opened. Host: %s."
/usr/OV/bin/addtrap -l xPDrmCred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 485 -t 2 -S 0 -c "Status Events" -f - -F "Fuse %s alarm cleared. Host: %s."
/usr/OV/bin/addtrap -l xPDkerrm       -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 486 -t 4 -S 4 -c "Status Events" -f - -F "Breaker %s position alarm %s. Host: %s."
/usr/OV/bin/addtrap -l xPDkerrmCred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 487 -t 2 -S 0 -c "Status Events" -f - -F "Breaker %s alarm cleared %s. Host: %s."
/usr/OV/bin/addtrap -l xPDkernge      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 488 -t 2 -S 0 -c "Status Events" -f - -F "Breaker/switch event. Host: %s."
/usr/OV/bin/addtrap -l xPDtaCComtch   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 489 -t 4 -S 4 -c "Status Events" -f - -F "XPDU data mismatch error. Host: %s."
/usr/OV/bin/addtrap -l xPDtaCComtchre -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 490 -t 2 -S 0 -c "Status Events" -f - -F "XPDU data mismatch error cleared. Host: %s."
/usr/OV/bin/addtrap -l xPDintncessM   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 491 -t 3 -S 2 -c "Status Events" -f - -F "PDU state changed to maintenance bypass. Host: %s."
/usr/OV/bin/addtrap -l xPDtiolMo      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 492 -t 2 -S 0 -c "Status Events" -f - -F "PDU state changed to UPS operational. Host: %s."
/usr/OV/bin/addtrap -l xATtornkRrm    -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 493 -t 3 -S 2 -c "Status Events" -f - -F "Generator inner wall rupture alarm. Host: %s."
/usr/OV/bin/addtrap -l xATtornkRrmCre -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 494 -t 2 -S 0 -c "Status Events" -f - -F "Generator inner wall rupture alarm cleared. Host: %s."
/usr/OV/bin/addtrap -l xATtorultrm    -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 495 -t 4 -S 4 -c "Status Events" -f - -F "Generator ground fault alarm. Host: %s."
/usr/OV/bin/addtrap -l xATtorultrmCre -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 496 -t 2 -S 0 -c "Status Events" -f - -F "Generator ground fault alarm cleared. Host: %s."
/usr/OV/bin/addtrap -l xATdPotorrm    -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 497 -t 3 -S 2 -c "Status Events" -f - -F "System load powered by generator. Host: %s."
/usr/OV/bin/addtrap -l xATdPotorrmCre -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 498 -t 2 -S 0 -c "Status Events" -f - -F "System load powered by generator alarm cleared. Host: %s."
/usr/OV/bin/addtrap -l xAPreUteTnsfrt -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 499 -t 2 -S 0 -c "Status Events" -f - -F "Start update transfer. Host: %s."
/usr/OV/bin/addtrap -l xAPreUteTnsf   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 500 -t 2 -S 0 -c "Status Events" -f - -F "Update transfer complete. Host: %s."
/usr/OV/bin/addtrap -l xAPreUteTnsfil -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 501 -t 4 -S 4 -c "Status Events" -f - -F "Update transfer failed. Host: %s."
/usr/OV/bin/addtrap -l upsyFailu      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 502 -t 3 -S 2 -c "Status Events" -f - -F "The PFC (Power Factor Correction) input relay failure exists. Host: %s."
/usr/OV/bin/addtrap -l upsyFailured   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 503 -t 2 -S 0 -c "Status Events" -f - -F "The PFC (Power Factor Correction) input relay failure cleared. Host: %s."
/usr/OV/bin/addtrap -l upstur         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 504 -t 3 -S 2 -c "Status Events" -f - -F "The inverter over temperature condition exists. Host: %s."
/usr/OV/bin/addtrap -l upsturred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 505 -t 2 -S 0 -c "Status Events" -f - -F "The inverter over temperature condition cleared. Host: %s."
/usr/OV/bin/addtrap -l upsttege       -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 506 -t 3 -S 2 -c "Status Events" -f - -F "The battery over voltage condition exists. Host: %s."
/usr/OV/bin/addtrap -l upsttegeCred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 507 -t 2 -S 0 -c "Status Events" -f - -F "The battery over voltage condition cleared. Host: %s."
/usr/OV/bin/addtrap -l upsEepromFault -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 508 -t 3 -S 2 -c "Status Events" -f - -F "The EEPROM fault exists. Host: %s."
/usr/OV/bin/addtrap -l upsultred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 509 -t 2 -S 0 -c "Status Events" -f - -F "The EEPROM fault cleared. Host: %s."
/usr/OV/bin/addtrap -l aruFnRurm      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 510 -t 3 -S 2 -c "Status Events" -f - -F "Fan Runhour Alarm. Host: %s."
/usr/OV/bin/addtrap -l aruFnRurmCred  -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 511 -t 2 -S 0 -c "Status Events" -f - -F "Fan Runhour Alarm Cleared. Host: %s."
/usr/OV/bin/addtrap -l aruFnPoncerm   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 512 -t 3 -S 2 -c "Status Events" -f - -F "Fan Health Alarm. Host: %s."
/usr/OV/bin/addtrap -l aruFnPoncermCr -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 513 -t 2 -S 0 -c "Status Events" -f - -F "Fan Health Alarm Cleared. Host: %s."
/usr/OV/bin/addtrap -l aruRntPrm      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 514 -t 3 -S 2 -c "Status Events" -f - -F "AC Redundancy Lost. Host: %s."
/usr/OV/bin/addtrap -l aruRntPrmCred  -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 515 -t 2 -S 0 -c "Status Events" -f - -F "AC Redundancy Restored. Host: %s."
/usr/OV/bin/addtrap -l apcDnge        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 516 -t 2 -S 0 -c "Status Events" -f - -F "A device configuration change has been made on a device. Host: %s."
/usr/OV/bin/addtrap -l apcE           -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 517 -t 2 -S 0 -c "Status Events" -f - -F "Sensor %s Connected. Host: %s."
/usr/OV/bin/addtrap -l apcE           -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 518 -t 4 -S 4 -c "Status Events" -f - -F "Sensor %s Disconnected. Host: %s."
/usr/OV/bin/addtrap -l apcExTetio     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 519 -t 4 -S 4 -c "Status Events" -f - -F "Over max temp on Sensor %s. Host: %s."
/usr/OV/bin/addtrap -l apcExTetiored  -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 520 -t 2 -S 0 -c "Status Events" -f - -F "Over max temp on Sensor %s cleared. Host: %s."
/usr/OV/bin/addtrap -l apcEtio        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 521 -t 3 -S 2 -c "Status Events" -f - -F "Overtemp on Sensor %s. Host: %s."
/usr/OV/bin/addtrap -l apcEtiored     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 522 -t 2 -S 0 -c "Status Events" -f - -F "Overtemp on Sensor %s cleared. Host: %s."
/usr/OV/bin/addtrap -l apcEtio        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 523 -t 3 -S 2 -c "Status Events" -f - -F "Undertemp on Sensor %s. Host: %s."
/usr/OV/bin/addtrap -l apcEtiored     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 524 -t 2 -S 0 -c "Status Events" -f - -F "Undertemp on Sensor %s cleared. Host: %s."
/usr/OV/bin/addtrap -l apcEtio        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 525 -t 4 -S 4 -c "Status Events" -f - -F "Under min temp on Sensor %s. Host: %s."
/usr/OV/bin/addtrap -l apcEtiored     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 526 -t 2 -S 0 -c "Status Events" -f - -F "Under min temp on Sensor %s cleared. Host: %s."
/usr/OV/bin/addtrap -l apcEteVtio     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 527 -t 4 -S 4 -c "Status Events" -f - -F "Short-term inc. temp rate violation. on Sensor %s. Host: %s."
/usr/OV/bin/addtrap -l apcEteVtiored  -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 528 -t 2 -S 0 -c "Status Events" -f - -F "Short-term inc. temp rate violation on Sensor %s cleared. Host: %s."
/usr/OV/bin/addtrap -l apcEteVtio     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 529 -t 4 -S 4 -c "Status Events" -f - -F "Short-term dec. temp rate violation. on Sensor %s. Host: %s."
/usr/OV/bin/addtrap -l apcEteVtiored  -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 530 -t 2 -S 0 -c "Status Events" -f - -F "Short-term dec. temp rate violation on Sensor %s cleared. Host: %s."
/usr/OV/bin/addtrap -l apcEteVtio     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 531 -t 4 -S 4 -c "Status Events" -f - -F "Long-term inc. temp rate violation. on Sensor %s. Host: %s."
/usr/OV/bin/addtrap -l apcEteVtiored  -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 532 -t 2 -S 0 -c "Status Events" -f - -F "Long-term inc. temp rate violation on Sensor %s cleared. Host: %s."
/usr/OV/bin/addtrap -l apcEteVtio     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 533 -t 4 -S 4 -c "Status Events" -f - -F "Long-term dec. temp rate violation. on Sensor %s. Host: %s."
/usr/OV/bin/addtrap -l apcEteVtiored  -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 534 -t 2 -S 0 -c "Status Events" -f - -F "Long-term dec. temp rate violation on Sensor %s cleared. Host: %s."
/usr/OV/bin/addtrap -l apcExHutio     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 535 -t 4 -S 4 -c "Status Events" -f - -F "Over max Humidity on Sensor %s. Host: %s."
/usr/OV/bin/addtrap -l apcExHutiored  -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 536 -t 2 -S 0 -c "Status Events" -f - -F "Over max Humidity on Sensor %s cleared. Host: %s."
/usr/OV/bin/addtrap -l apcEtio        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 537 -t 3 -S 2 -c "Status Events" -f - -F "Over Humidity on Sensor %s. Host: %s."
/usr/OV/bin/addtrap -l apcEtiored     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 538 -t 2 -S 0 -c "Status Events" -f - -F "Over Humidity on Sensor %s cleared. Host: %s."
/usr/OV/bin/addtrap -l apcEtio        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 539 -t 3 -S 2 -c "Status Events" -f - -F "Under Humidity on Sensor %s. Host: %s."
/usr/OV/bin/addtrap -l apcEtiored     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 540 -t 2 -S 0 -c "Status Events" -f - -F "Under Humidity on Sensor %s cleared. Host: %s."
/usr/OV/bin/addtrap -l apcEtio        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 541 -t 4 -S 4 -c "Status Events" -f - -F "Under min Humidity on Sensor %s. Host: %s."
/usr/OV/bin/addtrap -l apcEtiored     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 542 -t 2 -S 0 -c "Status Events" -f - -F "Under min Humidity on Sensor %s cleared. Host: %s."
/usr/OV/bin/addtrap -l apcBcon        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 543 -t 2 -S 0 -c "Status Events" -f - -F "Beacon Connected. Host: %s."
/usr/OV/bin/addtrap -l apcBcon        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 544 -t 4 -S 4 -c "Status Events" -f - -F "Beacon Disconnected. Host: %s."
/usr/OV/bin/addtrap -l apcBeaconOn    -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 545 -t 2 -S 0 -c "Status Events" -f - -F "Beacon On. Host: %s."
/usr/OV/bin/addtrap -l apcBeaconOff   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 546 -t 2 -S 0 -c "Status Events" -f - -F "Beacon Off. Host: %s."
/usr/OV/bin/addtrap -l apcOteAl       -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 547 -t 3 -S 2 -c "Status Events" -f - -F "Outlet %i to abnormal state . Host: %s."
/usr/OV/bin/addtrap -l apcOteNl       -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 548 -t 2 -S 0 -c "Status Events" -f - -F "Outlet %i to normal state . Host: %s."
/usr/OV/bin/addtrap -l apcOyStteAl    -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 549 -t 3 -S 2 -c "Status Events" -f - -F "Relay %i to abnormal state . Host: %s."
/usr/OV/bin/addtrap -l apcOyStteNl    -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 550 -t 2 -S 0 -c "Status Events" -f - -F "Relay %i to normal state . Host: %s."
/usr/OV/bin/addtrap -l apcHrdwreSteAl -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 551 -t 4 -S 4 -c "Status Events" -f - -F "Hardware is in an abnormal state. Host: %s."
/usr/OV/bin/addtrap -l apcHrdwreSteNl -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 552 -t 2 -S 0 -c "Status Events" -f - -F "Hardware is in its normal state. Host: %s."
/usr/OV/bin/addtrap -l apcClDictSteAl -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 553 -t 4 -S 4 -c "Status Events" -f - -F "Discrete contact %i to abnormal state . Host: %s."
/usr/OV/bin/addtrap -l apcClDictSteNl -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 554 -t 2 -S 0 -c "Status Events" -f - -F "Discrete contact %i to normal state . Host: %s."
/usr/OV/bin/addtrap -l apcWrnictSteAl -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 555 -t 3 -S 2 -c "Status Events" -f - -F "Discrete contact %i to abnormal state . Host: %s."
/usr/OV/bin/addtrap -l apcWrnictSteNl -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 556 -t 2 -S 0 -c "Status Events" -f - -F "Discrete contact %i to normal state . Host: %s."
/usr/OV/bin/addtrap -l apcItiolDictSt -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 557 -t 2 -S 0 -c "Status Events" -f - -F "Discrete contact %i to abnormal state . Host: %s."
/usr/OV/bin/addtrap -l apcItiolDictSt -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 558 -t 2 -S 0 -c "Status Events" -f - -F "Discrete contact %i to normal state . Host: %s."
/usr/OV/bin/addtrap -l apcAlogxThtio  -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 559 -t 4 -S 4 -c "Status Events" -f - -F "Over max threshold on input %s. Host: %s."
/usr/OV/bin/addtrap -l apcAlogxThtior -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 560 -t 2 -S 0 -c "Status Events" -f - -F "Over max threshold on input %s cleared. Host: %s."
/usr/OV/bin/addtrap -l apcAlogtio     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 561 -t 3 -S 2 -c "Status Events" -f - -F "Over high threshold on input %s. Host: %s."
/usr/OV/bin/addtrap -l apcAlogtiored  -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 562 -t 2 -S 0 -c "Status Events" -f - -F "Over high threshold on input %s cleared. Host: %s."
/usr/OV/bin/addtrap -l apcAlogtio     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 563 -t 3 -S 2 -c "Status Events" -f - -F "Under low threshold on input %s. Host: %s."
/usr/OV/bin/addtrap -l apcAlogtiored  -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 564 -t 2 -S 0 -c "Status Events" -f - -F "Under low threshold on input %s cleared. Host: %s."
/usr/OV/bin/addtrap -l apcAlogtio     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 565 -t 4 -S 4 -c "Status Events" -f - -F "Under min threshold on input %s. Host: %s."
/usr/OV/bin/addtrap -l apcAlogtiored  -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 566 -t 2 -S 0 -c "Status Events" -f - -F "Under min threshold on input %s cleared. Host: %s."
/usr/OV/bin/addtrap -l apcDrLo        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 567 -t 2 -S 0 -c "Status Events" -f - -F "Lost communications reset command has been issued. Host: %s."
/usr/OV/bin/addtrap -l apcD           -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 568 -t 2 -S 0 -c "Status Events" -f - -F "Device %s Connected. Host: %s."
/usr/OV/bin/addtrap -l apcD           -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 569 -t 4 -S 4 -c "Status Events" -f - -F "Device %s Disconnected. Host: %s."
/usr/OV/bin/addtrap -l apcU           -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 570 -t 2 -S 0 -c "Status Events" -f - -F "Unregistered user's RFID %s. Host: %s."
/usr/OV/bin/addtrap -l apcR           -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 571 -t 2 -S 0 -c "Status Events" -f - -F "Access denied, user %s. Host: %s."
/usr/OV/bin/addtrap -l apcRnge        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 572 -t 2 -S 0 -c "Status Events" -f - -F "Registered user configuration change. Host: %s."
/usr/OV/bin/addtrap -l apcD           -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 573 -t 2 -S 0 -c "Status Events" -f - -F "Door unlocked, door access user %s. Host: %s."
/usr/OV/bin/addtrap -l apcDoorLocked  -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 574 -t 2 -S 0 -c "Status Events" -f - -F "Door locked, door access user %s. Host: %s."
/usr/OV/bin/addtrap -l apcHndl        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 575 -t 2 -S 0 -c "Status Events" -f - -F "%s door handle opened. Host: %s."
/usr/OV/bin/addtrap -l apcHndl        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 576 -t 2 -S 0 -c "Status Events" -f - -F "%s door handle closed. Host: %s."
/usr/OV/bin/addtrap -l apcDoorOpened  -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 577 -t 2 -S 0 -c "Status Events" -f - -F "%s door opened. Host: %s."
/usr/OV/bin/addtrap -l apcDoorClosed  -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 578 -t 2 -S 0 -c "Status Events" -f - -F "%s door closed. Host: %s."
/usr/OV/bin/addtrap -l apcK           -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 580 -t 3 -S 2 -c "Status Events" -f - -F "Key override unlock has occurred on door %s. Host: %s."
/usr/OV/bin/addtrap -l apcK           -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 581 -t 2 -S 0 -c "Status Events" -f - -F "Key override lock has occurred on door %s. Host: %s."
/usr/OV/bin/addtrap -l apcForcedEntry -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 582 -t 4 -S 4 -c "Status Events" -f - -F "Forced entry has occurred on door %s. Host: %s."
/usr/OV/bin/addtrap -l apcFred        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 583 -t 2 -S 0 -c "Status Events" -f - -F "Forced entry has been cleared on door %s. Host: %s."
/usr/OV/bin/addtrap -l apcR           -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 584 -t 4 -S 4 -c "Status Events" -f - -F "Relock timeout on %s. Host: %s."
/usr/OV/bin/addtrap -l apcRred        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 585 -t 2 -S 0 -c "Status Events" -f - -F "Relock timout has been cleared on %s. Host: %s."
/usr/OV/bin/addtrap -l apcD           -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 586 -t 4 -S 4 -c "Status Events" -f - -F "A door sensor was disconnected on door %s. Host: %s."
/usr/OV/bin/addtrap -l apcD           -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 587 -t 2 -S 0 -c "Status Events" -f - -F "A door sensor was connected on door %s. Host: %s."
/usr/OV/bin/addtrap -l apcD           -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 588 -t 4 -S 4 -c "Status Events" -f - -F "Communication was lost with door %s. Host: %s."
/usr/OV/bin/addtrap -l apcDbli        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 589 -t 2 -S 0 -c "Status Events" -f - -F "Communication has been established with door %s. Host: %s."
/usr/OV/bin/addtrap -l apcRnge        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 590 -t 2 -S 0 -c "Status Events" -f - -F "Registered user access change. Host: %s."
/usr/OV/bin/addtrap -l apcUtusnge     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 591 -t 2 -S 0 -c "Status Events" -f - -F "Unregistered user status change. Host: %s."
/usr/OV/bin/addtrap -l apcDrUs        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 592 -t 2 -S 0 -c "Status Events" -f - -F "User configurations reset command has been issued. Host: %s."
/usr/OV/bin/addtrap -l upstteult      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 600 -t 3 -S 2 -c "Status Events" -f - -F "The battery temperature sensor fault exists. Host: %s."
/usr/OV/bin/addtrap -l upstteultred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 601 -t 2 -S 0 -c "Status Events" -f - -F "The battery temperature sensor fault cleared. Host: %s."
/usr/OV/bin/addtrap -l upsttertFult   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 602 -t 3 -S 2 -c "Status Events" -f - -F "A battery bus soft start fault exists. Host: %s."
/usr/OV/bin/addtrap -l upsttertFultre -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 603 -t 2 -S 0 -c "Status Events" -f - -F "A battery bus soft start fault exists cleared. Host: %s."
/usr/OV/bin/addtrap -l apcO           -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 604 -t 3 -S 2 -c "Status Events" -f - -F "An output short circuit condition exists. Host: %s."
/usr/OV/bin/addtrap -l apcOred        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 605 -t 2 -S 0 -c "Status Events" -f - -F "An output short circuit condition cleared. Host: %s."
/usr/OV/bin/addtrap -l apcOyFault     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 606 -t 3 -S 2 -c "Status Events" -f - -F "An output relay (or its driver) fault exists. Host: %s."
/usr/OV/bin/addtrap -l apcOyFaultred  -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 607 -t 2 -S 0 -c "Status Events" -f - -F "An output relay (or its driver) fault cleared. Host: %s."
/usr/OV/bin/addtrap -l upsPfcFault    -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 608 -t 3 -S 2 -c "Status Events" -f - -F "A PFC fault exists. Host: %s."
/usr/OV/bin/addtrap -l upsultred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 609 -t 2 -S 0 -c "Status Events" -f - -F "The PFC fault cleared. Host: %s."
/usr/OV/bin/addtrap -l apcDge         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 610 -t 3 -S 2 -c "Status Events" -f - -F "The DC bus voltage is too high. Host: %s."
/usr/OV/bin/addtrap -l apcDgeCred     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 611 -t 2 -S 0 -c "Status Events" -f - -F "The DC bus voltage is too high cleared. Host: %s."
/usr/OV/bin/addtrap -l upsult         -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 612 -t 3 -S 2 -c "Status Events" -f - -F "The inverter fault exists. Host: %s."
/usr/OV/bin/addtrap -l upsultred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 613 -t 2 -S 0 -c "Status Events" -f - -F "The inverter fault cleared. Host: %s."
/usr/OV/bin/addtrap -l apcAult        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 614 -t 3 -S 2 -c "Status Events" -f - -F "The A/D converter fault exists. Host: %s."
/usr/OV/bin/addtrap -l apcAultred     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 615 -t 2 -S 0 -c "Status Events" -f - -F "The A/D converter fault cleared. Host: %s."
/usr/OV/bin/addtrap -l apcLult        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 616 -t 3 -S 2 -c "Status Events" -f - -F "A logic power supply fault exists. Host: %s."
/usr/OV/bin/addtrap -l apcLultred     -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 617 -t 2 -S 0 -c "Status Events" -f - -F "A logic power supply fault cleared. Host: %s."
/usr/OV/bin/addtrap -l apcTnsflannceu -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 618 -t 3 -S 2 -c "Status Events" -f - -F "The DC component of the transformer's current is too high. Host: %s."
/usr/OV/bin/addtrap -l apcTnsflannceu -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 619 -t 2 -S 0 -c "Status Events" -f - -F "The DC component of the transformer's current is normal. Host: %s."
/usr/OV/bin/addtrap -l upsckfyFault   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 620 -t 3 -S 2 -c "Status Events" -f - -F "The backfeed relay (or its driver) has a fault. Host: %s."
/usr/OV/bin/addtrap -l upsckfyFaultre -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 621 -t 2 -S 0 -c "Status Events" -f - -F "The backfeed relay (or its driver) has a fault cleared. Host: %s."
/usr/OV/bin/addtrap -l upsssRyFault   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 622 -t 3 -S 2 -c "Status Events" -f - -F "A bypass relay (or its driver) has a fault. Host: %s."
/usr/OV/bin/addtrap -l upsssRyFaultre -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 623 -t 2 -S 0 -c "Status Events" -f - -F "A bypass relay (or its driver) has a fault cleared. Host: %s."
/usr/OV/bin/addtrap -l upsinRyFault   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 624 -t 4 -S 4 -c "Status Events" -f - -F "A main relay (or its driver) has a fault. Host: %s."
/usr/OV/bin/addtrap -l upsinRyFaultre -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 625 -t 2 -S 0 -c "Status Events" -f - -F "A main relay (or its driver) has a fault cleared. Host: %s."
/usr/OV/bin/addtrap -l xPDnchrm       -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 626 -t 4 -S 4 -c "Status Events" -f - -F "Branch circuit current %s is below threshold %s. Host: %s."
/usr/OV/bin/addtrap -l xPDnchrmCred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 627 -t 2 -S 0 -c "Status Events" -f - -F "Branch circuit low current %s alarm cleared. Host: %s."
/usr/OV/bin/addtrap -l xPDnchxAlrm    -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 628 -t 4 -S 4 -c "Status Events" -f - -F "Branch circuit current %s is above threshold %s. Host: %s."
/usr/OV/bin/addtrap -l xPDnchxAlrmCre -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 629 -t 2 -S 0 -c "Status Events" -f - -F "Branch circuit high current %i alarm cleared. Host: %s."
/usr/OV/bin/addtrap -l rPDd           -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 630 -t 3 -S 2 -c "Status Events" -f - -F "A Rack PDU has violated the outlet low load threshold. Host: %s."
/usr/OV/bin/addtrap -l rPDdClred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 631 -t 2 -S 0 -c "Status Events" -f - -F "The low load condition on a Rack PDU has been cleared. Host: %s."
/usr/OV/bin/addtrap -l rPDrOvd        -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 632 -t 3 -S 2 -c "Status Events" -f - -F "A Rack PDU is near an outlet overload condition. Host: %s."
/usr/OV/bin/addtrap -l rPDrOvdClred   -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 633 -t 2 -S 0 -c "Status Events" -f - -F "Rack PDU outlet near overload condition has cleared. Host: %s."
/usr/OV/bin/addtrap -l rPDd           -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 634 -t 4 -S 4 -c "Status Events" -f - -F "A Rack PDU is in an outlet overload condition. Host: %s."
/usr/OV/bin/addtrap -l rPDdClred      -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 635 -t 2 -S 0 -c "Status Events" -f - -F "The outlet overload condition on a Rack PDU has cleared. Host: %s."
/usr/OV/bin/addtrap -l apcTestTrap    -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 636 -t 2 -S 0 -c "Status Events" -f - -F "Test Trap. Host: %s."
/usr/OV/bin/addtrap -l basseFnFailure -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 637 -t 2 -S 0 -c "Status Events" -f - -F "The base module fan has been repaired. Host: %s."
/usr/OV/bin/addtrap -l apcDrmSteHrtbt -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 999 -t 2 -S 0 -c "Status Events" -f - -F ". Host: %s."
/usr/OV/bin/addtrap -l apcDrmSteTblet -n APC -i 1.3.6.1.4.1.318 -g 6 -o A -s 1000 -t 2 -S 0 -c "Status Events" -f - -F ". Host: %s."
