#! /usr/bin/env python
import unittest
import qsplit

doubleQuoteStr = 'This is a "quoted" string'

def assertEquals(got, expect, error):
    assert got == expect, '''%s: expected %s, got %s''' % (error, `expect`, `got`)


class DocTestCase(unittest.TestCase):
    def setUp(self):
        self.doctest = None
    def checkDoc(self):
        if self.doctest:
            errors, tests = self.doctest(0)
            assertEquals(errors, 0,
                         '%s Doctest failed, %s errors out of %s tests' % (self.__class__.__name__, errors, tests))
    

class QsplitTestCase(DocTestCase):
    def setUp(self):
        self.doctest = None
        

    def tearDown(self):
        pass

    def checkSplitString(self):
        lst = qsplit.qsplit(doubleQuoteStr)
        assertEquals(lst, ['This', 'is', 'a', '"quoted"', 'string'], 'incorrect double-quoted string')



def suite():
    qSuite = unittest.makeSuite(QsplitTestCase, 'check')
    suite = unittest.TestSuite((qSuite,))
    return suite


if __name__ == '__main__':
    testSuite = suite()
    runner = unittest.TextTestRunner()
    runner.run(testSuite)
        
